/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.events.server;

import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.event.Event;
import com.zigythebird.playeranimcore.event.EventResult;
import java.util.UUID;

public final class ServerEmoteEvents {
    public static final Event<EmoteVerifier> EMOTE_VERIFICATION = new Event(listeners -> (emote, userID) -> {
        for (EmoteVerifier listener : listeners) {
            EventResult result = listener.verify(emote, userID);
            if (result != EventResult.FAIL && result != EventResult.SUCCESS) continue;
            return result;
        }
        return EventResult.PASS;
    });
    public static final Event<EmotePlayEvent> EMOTE_PLAY = new Event(listeners -> (emote, tick, userID) -> {
        for (EmotePlayEvent listener : listeners) {
            listener.onEmotePlay(emote, tick, userID);
        }
    });
    public static final Event<EmoteStopEvent> EMOTE_STOP_BY_USER = new Event(listeners -> (emoteID, userID) -> {
        for (EmoteStopEvent listener : listeners) {
            listener.onStopEmote(emoteID, userID);
        }
    });

    @FunctionalInterface
    public static interface EmoteStopEvent {
        public void onStopEmote(UUID var1, UUID var2);
    }

    @FunctionalInterface
    public static interface EmotePlayEvent {
        public void onEmotePlay(Animation var1, float var2, UUID var3);
    }

    @FunctionalInterface
    public static interface EmoteVerifier {
        public EventResult verify(Animation var1, UUID var2);
    }
}

