/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.widget.preview.elemets;

import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.ExtraAnimationData;
import com.zigythebird.playeranimcore.easing.EasingType;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.widgets.PlayerPreview;
import io.github.kosmx.emotes.arch.screen.utils.EmotecraftTexture;
import io.github.kosmx.emotes.arch.screen.utils.WidgetOutliner;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import io.github.kosmx.emotes.arch.screen.widget.preview.PreviewFastChooseWidget;
import io.github.kosmx.emotes.main.EmoteHolder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_11876;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import org.joml.Vector2f;

public abstract class PlayerChooseElement
extends PlayerPreview
implements IChooseElement {
    private static final Float2FloatFunction EASING_TRANSFORMER = EasingType.EASE_IN_CIRC.buildTransformer(null);
    protected final AbstractFastChooseWidget parent;
    protected final int id;
    private boolean isAnimFinishing;

    public PlayerChooseElement(AbstractFastChooseWidget parent, GameProfile profile, int id) {
        super(profile, 0, 0, 0, 0, false);
        this.mannequin.emotecraft$getEmote().muteNbs = true;
        this.parent = parent;
        this.id = id;
        this.tick();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, this.isAnimFinishing ? mouseX : 0, this.isAnimFinishing ? mouseY : 0, partialTick);
    }

    protected abstract void updateRectangle(float var1);

    protected abstract void getDirectionVector(Vector2f var1);

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        float f;
        boolean doHoverPart = this.parent.controller.doHoverPart(this);
        AbstractFastChooseWidget abstractFastChooseWidget = this.parent;
        if (abstractFastChooseWidget instanceof PreviewFastChooseWidget) {
            PreviewFastChooseWidget widget = (PreviewFastChooseWidget)abstractFastChooseWidget;
            f = widget.getAnimTime();
        } else {
            f = 0.0f;
        }
        float progress = f;
        float easedProgress = 1.0f - EASING_TRANSFORMER.get(progress);
        this.isAnimFinishing = easedProgress > 0.9f;
        this.updateRectangle(easedProgress);
        this.renderBackground(guiGraphics);
        if (this.method_25367() && doHoverPart) {
            this.renderHover(guiGraphics);
        }
        EmoteHolder emoteHolder = this.getEmote();
        if (this.parent.controller.supportsKeyboardNavigation() && emoteHolder != null) {
            this.renderTileId(guiGraphics, easedProgress);
        }
        if (emoteHolder != null && PlatformTools.getConfig().showIconsIfPossible.get().booleanValue() && emoteHolder.getIconIdentifier() != null) {
            guiGraphics.method_25302(class_10799.field_56883, emoteHolder.getIconIdentifier(), this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.method_25368(), this.method_25364(), 256, 256, 256, 256);
        } else if (emoteHolder != null || !PlatformTools.getConfig().showIconsIfPossible.get().booleanValue()) {
            super.method_48579(guiGraphics, this.method_46426() + this.method_25368() / 2, this.method_46427() + this.method_25364() / 2, partialTick);
        }
        if (this.method_25367() && emoteHolder != null) {
            this.method_47400(class_7919.method_47407((class_2561)emoteHolder.name));
            this.method_47402(Duration.ZERO);
        } else {
            this.method_47400(null);
        }
        if (this.method_49606()) {
            guiGraphics.method_74037(this.method_37303() && doHoverPart ? (emoteHolder != null ? class_11876.field_62455 : class_11876.field_62458) : class_11876.field_62459);
        }
    }

    protected void renderBackground(class_332 guiGraphics) {
        class_2960 texture = EmotecraftTexture.MENU_LIST_BACKGROUND.identifier(class_310.method_1551().field_1687 != null);
        guiGraphics.method_25290(class_10799.field_56883, texture, this.method_46426() + 1, this.method_46427() + 1, (float)this.method_55442(), (float)this.method_55443(), this.method_25368() - 2, this.method_25364() - 2, 32, 32);
        WidgetOutliner.renderOutline(guiGraphics, this, -1);
    }

    protected void renderHover(class_332 guiGraphics) {
        guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), class_9848.method_61324((int)128, (int)66, (int)66, (int)66));
    }

    protected void renderTileId(class_332 gg, float easedProgress) {
        Vector2f dir = new Vector2f();
        this.getDirectionVector(dir);
        if (dir.x == 0.0f && dir.y == 0.0f) {
            return;
        }
        float inv = class_3532.method_48119((float)(dir.x * dir.x + dir.y * dir.y));
        float nx = dir.x * inv;
        float ny = dir.y * inv;
        float cx0 = (float)this.method_46426() + (float)this.method_25368() * 0.5f;
        float cy0 = (float)this.method_46427() + (float)this.method_25364() * 0.5f;
        float cx1 = (float)this.parent.method_46426() + (float)this.parent.method_25368() * 0.5f;
        float cy1 = (float)this.parent.method_46427() + (float)this.parent.method_25364() * 0.5f;
        float t = 1.0f - easedProgress;
        float cx = class_3532.method_16439((float)t, (float)cx0, (float)cx1);
        float cy = class_3532.method_16439((float)t, (float)cy0, (float)cy1);
        float halfW = (float)this.method_25368() * 0.5f;
        float halfH = (float)this.method_25364() * 0.5f;
        float edge = Math.min(halfW / Math.abs(nx), halfH / Math.abs(ny));
        float offset = edge + 14.0f + (float)Math.min(this.method_25368(), this.method_25364()) * 0.25f * t;
        float px = cx + nx * offset;
        float py = cy + ny * offset;
        class_327 font = class_310.method_1551().field_1772;
        String s = Integer.toString(this.id + 1);
        int n = Math.round(px - (float)font.method_1727(s) / 2.0f);
        Objects.requireNonNull(font);
        gg.method_25303(font, s, n, Math.round(py - 9.0f / 2.0f), -1);
    }

    @Override
    public void removed() {
        this.mannequin.stopEmote();
    }

    @Override
    public boolean hasEmote() {
        return PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] != null;
    }

    @Override
    public EmoteHolder getEmote() {
        UUID uuid = PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id];
        if (uuid != null) {
            EmoteHolder emote = (EmoteHolder)EmoteHolder.list.get(uuid);
            if (emote == null && this.parent.controller.doesShowInvalid()) {
                emote = new EmoteHolder.Empty(uuid);
            }
            return emote;
        }
        return null;
    }

    @Override
    public void clearEmote() {
        this.setEmote(null);
    }

    @Override
    public void setEmote(EmoteHolder emote) {
        PlatformTools.getConfig().fastMenuEmotes[this.parent.getCurrentPage()][this.id] = emote == null ? null : emote.getUuid();
    }

    @Override
    public void tick() {
        EmoteHolder holder = this.getEmote();
        float previewTick = holder == null ? 1.0f : PlayerChooseElement.calculatePreviewTick(holder.getEmote());
        boolean shouldPlayAgain = holder == null || holder.getEmote().loopType().shouldPlayAgain(null, holder.getEmote());
        boolean updated = this.playAnimation(holder == null ? null : holder.getEmote(), shouldPlayAgain ? Animation.LoopType.DEFAULT : Animation.LoopType.LOOP, true, previewTick);
        super.pause(!updated && !this.method_25367());
        if (updated || this.method_25367()) {
            super.tick();
        }
    }

    protected static float calculatePreviewTick(Animation animation) {
        float returnToTick;
        ExtraAnimationData data = animation.data();
        if (data.has("previewTick")) {
            return ((Float)data.getRaw("previewTick")).floatValue();
        }
        if (animation.loopType().shouldPlayAgain(null, animation) && (returnToTick = animation.loopType().restartFromTick(null, animation)) > 0.0f) {
            return (animation.length() - returnToTick) / 2.0f;
        }
        return animation.length() / 2.0f;
    }

    protected boolean method_25351(class_11910 button) {
        return this.parent.controller.isValidClickButton(button);
    }

    public boolean method_25402(class_11909 event, boolean bl) {
        if (super.method_25402(event, bl)) {
            return this.parent.controller.onClick(this, (class_11907)event, bl);
        }
        return false;
    }

    @Override
    public void method_25354(class_1144 handler) {
        if (!this.parent.controller.doHoverPart(this)) {
            return;
        }
        PlayerChooseElement.method_62888((class_1144)handler);
    }
}

