/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.emotePlay;

import com.zigythebird.playeranim.animation.PlayerAnimationController;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.animation.AnimationData;
import com.zigythebird.playeranimcore.animation.RawAnimation;
import com.zigythebird.playeranimcore.animation.keyframe.event.CustomKeyFrameEvents;
import com.zigythebird.playeranimcore.animation.keyframe.event.data.KeyFrameData;
import com.zigythebird.playeranimcore.enums.PlayState;
import com.zigythebird.playeranimcore.enums.State;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.utils.UnsafeMannequin;
import io.github.kosmx.emotes.main.emotePlay.MinecraftNbsPlayer;
import net.minecraft.class_11890;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5498;
import net.raphimc.noteblocklib.model.Song;
import org.jetbrains.annotations.Nullable;

public class EmotePlayer
extends PlayerAnimationController {
    @Nullable
    private MinecraftNbsPlayer song;
    public boolean perspective = false;
    public boolean muteNbs = false;

    public EmotePlayer(class_11890 avatar) {
        super(avatar, (controller, state, animSetter) -> PlayState.STOP);
    }

    protected void setAnimation(RawAnimation rawAnimation, float startAnimFrom) {
        State state = this.getAnimationState();
        super.setAnimation(rawAnimation, startAnimFrom);
        this.animationState = state;
    }

    protected void setupNewAnimation() {
        super.setupNewAnimation();
        Animation emote = this.getCurrentAnimationInstance();
        if (this.song != null) {
            this.song.stop();
        }
        this.song = emote != null && emote.data().has("song") ? new MinecraftNbsPlayer(this, (Song)emote.data().get("song").orElseThrow()) : null;
    }

    public void stop() {
        super.stop();
        this.stopTriggeredAnimation();
        this.animationQueue.clear();
        this.internalStop();
    }

    public void process(AnimationData state) {
        super.process(state);
        if (!this.animationState.isActive()) {
            this.internalStop();
        }
    }

    private void internalStop() {
        if (this.perspective && PlatformTools.getPerspective() == PlatformTools.getConfig().getCameraType()) {
            class_310.method_1551().field_1690.method_31043(class_5498.field_26664);
            this.perspective = false;
        }
        if (this.song != null) {
            this.song.stop();
        }
    }

    public static boolean isRunningEmote(@Nullable EmotePlayer emote) {
        return emote != null && emote.isActive();
    }

    protected <T extends KeyFrameData> void handleCustomKeyframe(T[] keyframes, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CustomKeyFrameEvents.CustomKeyFrameHandler<T> main, CustomKeyFrameEvents.CustomKeyFrameHandler<T> event, float animationTick, AnimationData animationData) {
        if (this.avatar instanceof UnsafeMannequin) {
            return;
        }
        super.handleCustomKeyframe(keyframes, main, event, animationTick, animationData);
    }

    protected void applyCustomPivotPoints() {
        if (this.song != null && !this.song.isFirstSongPlayed() && this.isActive() && !this.song.isRunning() && !this.muteNbs) {
            class_2561 nowPlaying = this.song.getNowPlaying();
            if (nowPlaying != null) {
                class_310.method_1551().field_1705.method_1732(nowPlaying);
            }
            this.song.setPaused(this.getAnimationState() == State.PAUSED);
            this.song.start();
        }
        super.applyCustomPivotPoints();
    }

    public void pause() {
        super.pause();
        if (this.song != null) {
            this.song.setPaused(true);
        }
    }

    public void unpause() {
        super.unpause();
        if (this.song != null) {
            this.song.setPaused(false);
        }
    }
}

