/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.network.LegacyAnimationBinary;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import java.io.IOException;
import java.nio.ByteBuffer;

public class EmoteDataPacket
extends AbstractNetworkPacket {
    @Override
    public void write(ByteBuffer buf, NetData config) {
        byte version = this.getVer(config.versions);
        assert (config.emoteData != null);
        buf.putInt((int)config.tick);
        LegacyAnimationBinary.write((Animation)config.emoteData, (ByteBuffer)buf, (int)version);
    }

    @Override
    public void read(ByteBuffer buf, NetData config, int version) throws IOException {
        config.tick = buf.getInt();
        config.emoteData = LegacyAnimationBinary.read((ByteBuffer)buf, (int)version);
        config.valid = true;
    }

    @Override
    public byte getID() {
        return 0;
    }

    @Override
    public byte getVer() {
        return (byte)LegacyAnimationBinary.getCurrentVersion();
    }

    @Override
    public boolean doWrite(NetData data) {
        return data.emoteData != null && data.stopEmoteID == null && !data.versions.containsKey((byte)-103);
    }

    @Override
    public int calculateSize(NetData config) {
        if (config.emoteData == null || config.versions.containsKey((byte)-103)) {
            return 0;
        }
        return LegacyAnimationBinary.calculateSize((Animation)config.emoteData, (int)this.getVer(config.versions)) + 4;
    }
}

