/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.network.objects;

import io.github.kosmx.emotes.common.network.CommonNetwork;
import io.github.kosmx.emotes.common.network.objects.AbstractNetworkPacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import java.io.IOException;
import java.nio.ByteBuffer;

public class PlayerDataPacket
extends AbstractNetworkPacket {
    @Override
    public byte getID() {
        return 1;
    }

    @Override
    public byte getVer() {
        return 1;
    }

    @Override
    public void read(ByteBuffer byteBuffer, NetData config, int version) throws IOException {
        config.player = CommonNetwork.readUUID(byteBuffer);
        if (version >= 1) {
            config.isForced = byteBuffer.get() != 0;
        }
    }

    @Override
    public void write(ByteBuffer byteBuffer, NetData config) throws IOException {
        assert (config.player != null);
        CommonNetwork.writeUUID(byteBuffer, config.player);
        byteBuffer.put(config.isForced ? (byte)1 : 0);
    }

    @Override
    public boolean doWrite(NetData config) {
        return config.player != null;
    }

    @Override
    public int calculateSize(NetData config) {
        return 17;
    }
}

