/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.tools.ServiceLoaderUtil;
import io.github.kosmx.emotes.mc.McUtils;
import java.util.Collection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public interface NetworkPlatformTools {
    public static final NetworkPlatformTools INSTANCE = (NetworkPlatformTools)ServiceLoaderUtil.loadServices(NetworkPlatformTools.class).findAny().orElseThrow();
    public static final CustomPacketPayload.Type<EmotePacketPayload> EMOTE_CHANNEL_ID = new CustomPacketPayload.Type(McUtils.newIdentifier((String)"emote"));
    public static final CustomPacketPayload.Type<EmotePacketPayload> STREAM_CHANNEL_ID = new CustomPacketPayload.Type(McUtils.newIdentifier((String)"stream"));

    public boolean canSendPlay(ServerPlayer var1, Identifier var2);

    public boolean canSendConfig(ServerConfigurationPacketListenerImpl var1, Identifier var2);

    public Collection<ServerPlayer> getTrackedBy(Entity var1);

    @NotNull
    public static Packet<?> createClientboundPacket(@NotNull CustomPacketPayload.Type<?> id, @NotNull EmotePacket packet) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)new EmotePacketPayload(id, packet));
    }

    public MinecraftServer getServer();

    @NotNull
    public static Packet<?> playPacket(@NotNull EmotePacket packet) {
        return NetworkPlatformTools.createClientboundPacket(EMOTE_CHANNEL_ID, packet);
    }

    @NotNull
    public static Packet<?> streamPacket(@NotNull EmotePacket packet) {
        return NetworkPlatformTools.createClientboundPacket(STREAM_CHANNEL_ID, packet);
    }
}

