/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import io.github.kosmx.emotes.arch.network.AbstractServerNetwork;
import io.github.kosmx.emotes.arch.network.AvatarServerPlayNetwork;
import io.github.kosmx.emotes.arch.network.EmotesMixinNetwork;
import io.github.kosmx.emotes.arch.network.ModdedServerPlayNetwork;
import io.github.kosmx.emotes.arch.network.NetworkPlatformTools;
import io.github.kosmx.emotes.common.network.EmotePacket;
import io.github.kosmx.emotes.common.network.objects.NetData;
import io.github.kosmx.emotes.server.network.AbstractServerEmotePlay;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class CommonServerNetworkHandler
extends AbstractServerEmotePlay<AbstractServerNetwork> {
    private final Map<UUID, AvatarServerPlayNetwork> nonPlayers = new WeakHashMap<UUID, AvatarServerPlayNetwork>();

    public void receiveMessage(EmotePacket packet, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            try {
                this.receiveMessage(packet, CommonServerNetworkHandler.getHandler(serverPlayer.connection));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ModdedServerPlayNetwork getHandler(ServerGamePacketListenerImpl handler) {
        return ((EmotesMixinNetwork)handler).emotecraft$getServerNetworkInstance();
    }

    public void receiveStreamMessage(EmotePacket packet, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.receiveStreamMessage(serverPlayer, CommonServerNetworkHandler.getHandler(serverPlayer.connection), packet);
        }
    }

    public void receiveStreamMessage(ServerPlayer player, ModdedServerPlayNetwork handler, EmotePacket packet) {
        player.connection.disconnect((Component)Component.literal((String)"This server does not support streaming!"));
    }

    protected UUID getUUIDFromPlayer(AbstractServerNetwork player) {
        return player.getAvatar().getUUID();
    }

    protected AbstractServerNetwork getPlayerFromUUID(UUID player) {
        ServerPlayer serverPlayer = NetworkPlatformTools.INSTANCE.getServer().getPlayerList().getPlayer(player);
        if (serverPlayer != null) {
            return this.getPlayerNetworkInstance(serverPlayer);
        }
        if (!this.nonPlayers.containsKey(player)) {
            for (ServerLevel level : NetworkPlatformTools.INSTANCE.getServer().getAllLevels()) {
                Entity entity = level.getEntity(player);
                if (!(entity instanceof Avatar)) continue;
                Avatar avatar = (Avatar)entity;
                this.nonPlayers.put(player, new AvatarServerPlayNetwork(avatar));
                break;
            }
        }
        return this.nonPlayers.get(player);
    }

    public AbstractServerNetwork getPlayerNetworkInstance(ServerPlayer player) {
        return ((EmotesMixinNetwork)player.connection).emotecraft$getServerNetworkInstance();
    }

    protected void sendForEveryoneElse(NetData data, AbstractServerNetwork player) {
        for (ServerPlayer target : NetworkPlatformTools.INSTANCE.getTrackedBy((Entity)player.getAvatar())) {
            AbstractServerNetwork targetInstance = this.getPlayerNetworkInstance(target);
            if (targetInstance == player || !NetworkPlatformTools.INSTANCE.canSendPlay(target, NetworkPlatformTools.EMOTE_CHANNEL_ID.id())) continue;
            this.sendForPlayer(data, player, targetInstance);
        }
    }

    public static CommonServerNetworkHandler getInstance() {
        return (CommonServerNetworkHandler)AbstractServerEmotePlay.getInstance();
    }
}

