/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.network.ClientEmotePlay;
import io.github.kosmx.emotes.mc.EmoteArgumentProvider;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class ClientCommands {
    public static final Component FORCED = Component.translatable((String)"emotecraft.cant.override.forced");

    public static <T> void register(CommandDispatcher<T> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"emotes-client").then(Commands.literal((String)"play").then(Commands.argument((String)"emote", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EmoteArgumentProvider(ClientCommands::getEmotes)).executes(ctx -> {
            if (!ClientEmotePlay.clientStartLocalEmote(EmoteArgumentProvider.getEmote(ClientCommands.getEmotes((CommandContext<CommandSourceStack>)ctx), (CommandContext)ctx, (String)"emote"))) {
                throw new SimpleCommandExceptionType((Message)FORCED).create();
            }
            return 0;
        })))).then(Commands.literal((String)"stop").executes(ctx -> {
            if (ClientEmotePlay.isForcedEmote()) {
                throw new SimpleCommandExceptionType((Message)FORCED).create();
            }
            ClientEmotePlay.clientStopLocalEmote();
            return 0;
        })));
    }

    private static Map<UUID, Animation> getEmotes(CommandContext<CommandSourceStack> context) {
        return EmoteHolder.list.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((EmoteHolder)entry.getValue()).emote));
    }
}

