/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.config;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.common.SerializableConfig;
import io.github.kosmx.emotes.common.tools.BiMap;
import io.github.kosmx.emotes.main.config.CloseWheel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.CameraType;

public class ClientConfig
extends SerializableConfig {
    public final List<SerializableConfig.ConfigEntry<?>> legacy = new ArrayList();
    public final SerializableConfig.ConfigEntry<Boolean> oldChooseWheel = new SerializableConfig.ConfigEntry("oldChooseWheel", (Object)false, false, this.legacy);
    public final SerializableConfig.ConfigEntry<Boolean> showIconsIfPossible = new SerializableConfig.ConfigEntry("showIconsIfPossible", (Object)false, false, this.legacy);
    public final SerializableConfig.EnumConfigEntry<CloseWheel> closeWheelType = new SerializableConfig.EnumConfigEntry("closeWheelType", (Enum)CloseWheel.PRESS, true, this.basics);
    public final SerializableConfig.ConfigEntry<Boolean> enableWheelKeyboardNav = new SerializableConfig.ConfigEntry("enableWheelKeyboardNav", (Object)true, false, this.basics);
    public final SerializableConfig.ConfigEntry<Boolean> enablePerspective = new SerializableConfig.ConfigEntry("perspective", (Object)true, false, this.basics);
    public final SerializableConfig.ConfigEntry<Boolean> frontAsTPPerspective = new SerializableConfig.ConfigEntry("default3rdPersonFront", (Object)false, false, this.basics);
    public final SerializableConfig.ConfigEntry<Boolean> checkPose = new SerializableConfig.ConfigEntry("checkPose", (Object)true, true, this.expert);
    public final SerializableConfig.ConfigEntry<Boolean> alwaysOpenEmoteScreen = new SerializableConfig.ConfigEntry("alwaysOpenScreen", (Object)false, true, this.basics);
    public final SerializableConfig.ConfigEntry<Boolean> alwaysValidate = new SerializableConfig.ConfigEntry("alwaysValidateEmote", (Object)false, true, this.expert);
    public final SerializableConfig.ConfigEntry<Boolean> enablePlayerSafety = new SerializableConfig.ConfigEntry("playersafety", (Object)true, true, this.expert);
    public final SerializableConfig.ConfigEntry<Float> stopThreshold = new SerializableConfig.FloatConfigEntry(this, "stopthreshold", "stopThreshold", Float.valueOf(0.04f), true, this.expert, "options.generic_value", -3.912f, 8.0f, 0.0f){

        public double getConfigVal() {
            return Math.log(((Float)this.get()).floatValue());
        }

        public void setConfigVal(double newVal) {
            this.set(Float.valueOf((float)Math.exp(newVal)));
        }
    };
    public final SerializableConfig.ConfigEntry<Float> yRatio = new SerializableConfig.FloatConfigEntry(this, "yratio", "yRatio", Float.valueOf(0.75f), true, this.expert, "options.percent_value", 0.0f, 100.0f, 1.0f){

        public double getConfigVal() {
            return ((Float)this.get()).floatValue() * 100.0f;
        }

        public void setConfigVal(double newVal) {
            this.set(Float.valueOf((float)(newVal / 100.0)));
        }

        public double getTextVal() {
            return this.getConfigVal();
        }
    };
    public final SerializableConfig.ConfigEntry<Boolean> showHiddenConfig = new SerializableConfig.ConfigEntry("showHiddenConfig", (Object)false, true, this.expert, false);
    public BiMap<UUID, InputConstants.Key> emoteKeyMap = new BiMap();
    public UUID[][] fastMenuEmotes = new UUID[15][8];

    public ClientConfig() {
        this.loadEmotesServerSide.set((Object)false);
    }

    public void iterate(Consumer<SerializableConfig.ConfigEntry<?>> consumer) {
        super.iterate(consumer);
        this.legacy.forEach(consumer);
    }

    public CameraType getCameraType() {
        return (Boolean)this.frontAsTPPerspective.get() != false ? CameraType.THIRD_PERSON_FRONT : CameraType.THIRD_PERSON_BACK;
    }
}

