/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.ingame;

import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.EmotecraftClientMod;
import io.github.kosmx.emotes.arch.screen.ingame.FullMenuScreen;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.FastChooseController;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import io.github.kosmx.emotes.arch.screen.widget.preview.PreviewFastChooseWidget;
import io.github.kosmx.emotes.main.config.CloseWheel;
import io.github.kosmx.emotes.main.network.ClientPacketManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jspecify.annotations.NonNull;

public class FastMenuScreen
extends Screen
implements FastChooseController {
    protected static final Component TITLE = Component.translatable((String)"emotecraft.fastmenu");
    private static final Component WARN_NO_EMOTECRAFT = Component.translatable((String)"emotecraft.no_server");
    private static final Component WARN_ONLY_PROXY = Component.translatable((String)"emotecraft.only_proxy");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 0, 33);
    protected final Screen parent;
    protected AbstractFastChooseWidget fastMenu;

    public FastMenuScreen(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    public void init() {
        Objects.requireNonNull(this.font);
        this.layout.setHeaderHeight(9 * 2);
        if (ClientPacketManager.isRemoteAvailable()) {
            this.layout.setHeaderHeight(0);
        } else if (ClientPacketManager.isAvailableProxy()) {
            this.layout.addTitleHeader(WARN_ONLY_PROXY, this.font);
        } else {
            this.layout.addTitleHeader(WARN_NO_EMOTECRAFT, this.font);
        }
        this.fastMenu = (AbstractFastChooseWidget)this.layout.addToContents((LayoutElement)new PreviewFastChooseWidget((FastChooseController)this, true, 0, 0, 512), LayoutSettings::alignVerticallyMiddle);
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).width(120).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)FullMenuScreen.TITLE, button -> this.minecraft.setScreen((Screen)new FullMenuScreen(this))).width(120).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        if (this.fastMenu != null) {
            this.fastMenu.setSize(Math.min(Math.round(Math.min((float)this.width * 0.8f, (float)(this.height - this.layout.getHeaderHeight()) * 0.8f)), 512));
        }
        this.layout.arrangeElements();
    }

    public void removed() {
        super.removed();
        if (this.fastMenu != null) {
            this.fastMenu.removed();
        }
    }

    protected void renderBlurredBackground(@NonNull GuiGraphics guiGraphics) {
    }

    public boolean keyPressed(@NonNull KeyEvent keyEvent) {
        if (this.supportsKeyboardNavigation()) {
            List<IChooseElement> chooseElements = this.fastMenu.getChooseElements();
            int digit = keyEvent.getDigit() - 1;
            if (digit >= 0 && digit < chooseElements.size() && this.onClick(chooseElements.get(digit), (InputWithModifiers)keyEvent, false)) {
                return true;
            }
        }
        if (PlatformTools.getConfig().closeWheelType.get() == CloseWheel.PRESS && EmotecraftClientMod.OPEN_MENU_KEY.matches(keyEvent)) {
            return this.onToggleKey((InputWithModifiers)keyEvent);
        }
        if (super.keyPressed(keyEvent)) {
            if (this.supportsKeyboardNavigation() && (keyEvent.isRight() || keyEvent.isLeft())) {
                this.fastMenu.keyPressed(keyEvent);
            }
            return true;
        }
        return false;
    }

    public boolean keyReleased(@NonNull KeyEvent keyEvent) {
        if (PlatformTools.getConfig().closeWheelType.get() == CloseWheel.HOLD && EmotecraftClientMod.OPEN_MENU_KEY.matches(keyEvent)) {
            return this.onToggleKey((InputWithModifiers)keyEvent);
        }
        return super.keyReleased(keyEvent);
    }

    public boolean mouseClicked(@NonNull MouseButtonEvent event, boolean bl) {
        if (PlatformTools.getConfig().closeWheelType.get() == CloseWheel.PRESS && EmotecraftClientMod.OPEN_MENU_KEY.matchesMouse(event)) {
            return this.onToggleKey((InputWithModifiers)event);
        }
        return super.mouseClicked(event, bl);
    }

    public boolean mouseReleased(@NonNull MouseButtonEvent event) {
        if (PlatformTools.getConfig().closeWheelType.get() == CloseWheel.HOLD && EmotecraftClientMod.OPEN_MENU_KEY.matchesMouse(event)) {
            return this.onToggleKey((InputWithModifiers)event);
        }
        return super.mouseReleased(event);
    }

    protected boolean onToggleKey(InputWithModifiers event) {
        this.onClose();
        return true;
    }

    public void tick() {
        super.tick();
        if (this.fastMenu != null) {
            this.fastMenu.tick();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    @Override
    public boolean doHoverPart(IChooseElement part) {
        return part.hasEmote();
    }

    @Override
    public boolean isValidClickButton(MouseButtonInfo info) {
        return info.button() == 0;
    }

    @Override
    public boolean onClick(IChooseElement element, InputWithModifiers event, boolean unused) {
        if (element.getEmote() != null) {
            boolean bl = element.getEmote().playEmote();
            if (bl) {
                Minecraft.getInstance().setScreen(null);
            }
            return bl;
        }
        return false;
    }

    @Override
    public boolean doesShowInvalid() {
        return false;
    }

    @Override
    public boolean supportsKeyboardNavigation() {
        return (Boolean)PlatformTools.getConfig().enableWheelKeyboardNav.get();
    }
}

