/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.screen.ConfigScreen;
import io.github.kosmx.emotes.arch.gui.widgets.EmoteListWidget;
import io.github.kosmx.emotes.arch.screen.components.EmoteSubScreen;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.FastChooseController;
import io.github.kosmx.emotes.arch.screen.widget.IChooseElement;
import io.github.kosmx.emotes.arch.screen.widget.preview.PreviewFastChooseWidget;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.server.config.Serializer;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class EmoteMenu
extends EmoteSubScreen
implements FastChooseController {
    private static final Component TITLE = Component.translatable((String)"emotecraft.menu");
    public static final Component OPEN_FOLDER = Component.translatable((String)"emotecraft.openFolder");
    private static final Component OPTIONS = Component.translatable((String)"emotecraft.options.options");
    public static final Component RESET = Component.translatable((String)"controls.reset");
    private static final Component KEYBIND = Component.translatable((String)"emotecraft.options.keybind");
    private static final Component FASTMENU = Component.translatable((String)"emotecraft.options.fastmenu").append(CommonComponents.SPACE).append((Component)Component.translatable((String)"emotecraft.options.fastmenu2")).append(CommonComponents.SPACE).append((Component)Component.translatable((String)"emotecraft.options.fastmenu3"));
    private static final Component SURE = Component.translatable((String)"emotecraft.sure");
    private static final Component SURE2 = Component.translatable((String)"emotecraft.sure2");
    private static final Component RESET_ONE = Component.translatable((String)"controls.reset");
    private static final Component RESET_ALL = Component.translatable((String)"controls.resetAll");
    private static final Component RESET_ALL_TITLE = Component.translatable((String)"emotecraft.resetAllKeys.title");
    private static final Component RESET_ALL_MSG = Component.translatable((String)"emotecraft.resetAllKeys.message");
    public long activeKeyTime;
    private Button setKeyButton;
    private Button resetButton;
    private boolean resetOnlySelected;
    protected AbstractFastChooseWidget fastChoose;

    public EmoteMenu(Screen parent) {
        super(TITLE, true, parent);
    }

    @Override
    protected void addContents() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.horizontal().spacing(8));
        this.list = (EmoteListWidget)linearLayout.addChild((LayoutElement)this.newEmoteListWidget(), LayoutSettings::alignVerticallyBottom);
        this.list.setCompactMode(true);
        this.addOptions();
        GridLayout gridLayout = (GridLayout)linearLayout.addChild((LayoutElement)new GridLayout());
        gridLayout.defaultCellSetting().padding(4, 2, 4, 0);
        GridLayout.RowHelper rowHelper = gridLayout.createRowHelper(2);
        rowHelper.addChild((LayoutElement)new MultiLineTextWidget(KEYBIND, this.font).setMaxWidth(240), 2);
        this.setKeyButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)InputConstants.UNKNOWN.getDisplayName(), button -> {
            if (this.list != null && this.list.getSelected() != null) {
                this.activeKeyTime = 200L;
            }
        }).width(120).build());
        this.setKeyButton.active = false;
        this.resetButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)RESET, this::resetKeyAction).width(120).build());
        this.resetButton.active = false;
        rowHelper.addChild((LayoutElement)new MultiLineTextWidget(FASTMENU, this.font).setMaxWidth(240), 2, gridLayout.newCellSettings().paddingTop(8));
        this.fastChoose = (AbstractFastChooseWidget)rowHelper.addChild((LayoutElement)new PreviewFastChooseWidget((FastChooseController)this, false, 0, 0, 256), 2, rowHelper.newCellSettings().alignHorizontallyCenter().paddingTop(4));
    }

    @Override
    protected void addOptions() {
        if (this.list != null) {
            this.list.setEmotes((Iterable<EmoteHolder>)EmoteHolder.list, true);
        }
    }

    @Override
    protected void addFooter() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        if (this.list != null) {
            linearLayout.addChild((LayoutElement)this.list.createBackButton());
        }
        linearLayout.addChild((LayoutElement)Button.builder((Component)OPEN_FOLDER, button -> PlatformTools.openExternalEmotesDir()).width(120).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(120).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)OPTIONS, button -> this.minecraft.setScreen((Screen)new ConfigScreen(this))).width(120).build());
    }

    private void resetKeyAction(Button button) {
        if (this.resetOnlySelected) {
            if (this.list == null || this.list.getFocused() == null) {
                return;
            }
            PlatformTools.getConfig().emoteKeyMap.removeL((Object)this.list.getFocusedEmote().getUuid());
            this.onPressed((EmoteListWidget.ListEntry)this.list.getSelected());
        } else {
            this.minecraft.setScreen((Screen)new ConfirmScreen(aBoolean -> {
                if (aBoolean) {
                    PlatformTools.getConfig().emoteKeyMap.clear();
                    this.onPressed((EmoteListWidget.ListEntry)this.list.getSelected());
                }
                this.minecraft.setScreen((Screen)this);
            }, RESET_ALL_TITLE, (Component)RESET_ALL_MSG.copy().append(" (" + PlatformTools.getConfig().emoteKeyMap.size() + ")")));
        }
    }

    @Override
    protected void repositionElements() {
        if (this.fastChoose != null) {
            this.fastChoose.setSize(Math.min(Math.round(Math.min((float)this.width / 2.5f, (float)this.height / 2.3f)), 256));
        }
        super.repositionElements();
    }

    @Override
    protected void onPressed(EmoteListWidget.ListEntry selected) {
        if (this.resetButton == null) {
            return;
        }
        this.setKeyButton.active = this.resetButton.active = selected instanceof EmoteListWidget.EmoteEntry;
        if (selected instanceof EmoteListWidget.EmoteEntry) {
            EmoteListWidget.EmoteEntry entry = (EmoteListWidget.EmoteEntry)selected;
            this.setKeyButton.setMessage(EmoteMenu.getKey(entry.getEmote().getUuid()).getDisplayName());
            this.resetOnlySelected = PlatformTools.getConfig().emoteKeyMap.containsL((Object)entry.getEmote().getUuid());
        } else {
            this.resetOnlySelected = false;
        }
        if (this.resetOnlySelected) {
            this.resetButton.active = true;
            this.resetButton.setMessage(RESET_ONE);
        } else if (!PlatformTools.getConfig().emoteKeyMap.isEmpty()) {
            this.resetButton.active = true;
            this.resetButton.setMessage((Component)RESET_ALL.copy().append(" (" + PlatformTools.getConfig().emoteKeyMap.size() + ")"));
        } else {
            this.resetButton.active = false;
            this.resetButton.setMessage(RESET_ONE);
        }
    }

    @Override
    public void tick() {
        if (this.activeKeyTime == 1L) {
            this.setFocused(null);
        }
        if (this.activeKeyTime != 0L) {
            --this.activeKeyTime;
        }
        super.tick();
        if (this.fastChoose != null) {
            this.fastChoose.tick();
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        if (this.activeKeyTime != 0L && this.list != null && this.list.getFocused() != null) {
            return this.setKey(InputConstants.Type.MOUSE.getOrCreate(event.button()));
        }
        return super.mouseClicked(event, bl);
    }

    private boolean setKey(InputConstants.Key key) {
        boolean bl = false;
        if (this.list != null && this.list.getFocused() != null) {
            bl = true;
            if (!this.applyKey(false, this.list.getFocusedEmote(), key)) {
                this.minecraft.setScreen((Screen)new ConfirmScreen(choice -> {
                    if (choice) {
                        this.applyKey(true, this.list.getFocusedEmote(), key);
                    }
                    this.minecraft.setScreen((Screen)this);
                }, SURE, SURE2));
            }
        }
        return bl;
    }

    private boolean applyKey(boolean force, EmoteHolder emote, InputConstants.Key key) {
        boolean bl = true;
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            if (key.equals((Object)InputConstants.UNKNOWN) || !EmoteMenu.getKey(emoteHolder.getUuid()).equals((Object)key)) continue;
            bl = false;
            if (!force) continue;
            PlatformTools.getConfig().emoteKeyMap.removeL((Object)emoteHolder.getUuid());
        }
        if (bl || force) {
            PlatformTools.getConfig().emoteKeyMap.put((Object)emote.getUuid(), (Object)key);
            this.onPressed((EmoteListWidget.ListEntry)this.list.getSelected());
        }
        this.activeKeyTime = 0L;
        return bl;
    }

    @NotNull
    public static InputConstants.Key getKey(UUID emoteID) {
        InputConstants.Key key = (InputConstants.Key)PlatformTools.getConfig().emoteKeyMap.getR((Object)emoteID);
        if (key == null) {
            return InputConstants.UNKNOWN;
        }
        return key;
    }

    @Override
    public void removed() {
        super.removed();
        Serializer.INSTANCE.saveConfig();
        if (this.fastChoose != null) {
            this.fastChoose.removed();
        }
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.list != null && this.list.getFocused() != null && this.activeKeyTime != 0L) {
            if (keyEvent.isEscape()) {
                return this.setKey(InputConstants.UNKNOWN);
            }
            return this.setKey(InputConstants.getKey((KeyEvent)keyEvent));
        }
        return super.keyPressed(keyEvent);
    }

    @Override
    public boolean isValidClickButton(MouseButtonInfo info) {
        return (info.button() == 0 || info.button() == 1) && this.activeKeyTime == 0L;
    }

    @Override
    public boolean onClick(IChooseElement element, InputWithModifiers event, boolean bl) {
        if (this.activeKeyTime != 0L) {
            return false;
        }
        if (event.input() == 1) {
            element.clearEmote();
            return true;
        }
        if (this.list != null && this.list.getFocused() != null) {
            element.setEmote(this.list.getFocusedEmote());
            return true;
        }
        return false;
    }

    @Override
    public boolean doHoverPart(IChooseElement part) {
        return this.activeKeyTime == 0L;
    }

    @Override
    public boolean doesShowInvalid() {
        return true;
    }

    @Override
    public boolean supportsKeyboardNavigation() {
        return false;
    }
}

