/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.main.emotePlay;

import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.emotePlay.instances.SoundDirectInstance;
import io.github.kosmx.emotes.main.emotePlay.instances.SoundEventInstance;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.phys.Vec3;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.nbs.model.NbsCustomInstrument;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.instrument.Instrument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstrumentConventer {
    public static SoundInstance getInstrument(Note note, Vec3 pos) {
        Instrument noteBlock;
        Instrument instrument = note.getInstrument();
        if (instrument instanceof MinecraftInstrument) {
            MinecraftInstrument instrument2 = (MinecraftInstrument)instrument;
            noteBlock = InstrumentConventer.convertToNoteBlock(instrument2.mcId());
            return InstrumentConventer.createForNoteBlock((NoteBlockInstrument)noteBlock, pos, note.getVolume(), note.getPitch());
        }
        noteBlock = note.getInstrument();
        if (noteBlock instanceof NbsCustomInstrument) {
            ResourceLocation sound;
            NbsCustomInstrument instrument3 = (NbsCustomInstrument)noteBlock;
            String file = instrument3.getSoundFilePathOr("").replace(File.separatorChar, '/');
            if (file.endsWith(".ogg")) {
                file = file.substring(0, file.length() - 4);
            }
            if ((sound = InstrumentConventer.parseSoundFile(Minecraft.getInstance().getResourceManager(), file)) != null) {
                return new SoundDirectInstance(sound, note.getVolume(), note.getPitch(), pos);
            }
            SoundEvent event = InstrumentConventer.parseSoundName(instrument3.getNameOr(""));
            if (event != null) {
                return new SoundEventInstance(event, note.getVolume(), note.getPitch(), pos);
            }
            CommonData.LOGGER.warn("Failed parse custom instrument: name={}, file={}", (Object)instrument3.getNameOr(""), (Object)file);
            return new SoundDirectInstance(SoundManager.EMPTY_SOUND, note.getVolume(), note.getPitch(), pos);
        }
        CommonData.LOGGER.warn("Unsupported instrument type: {}", (Object)note.getInstrument().getClass().getName());
        return InstrumentConventer.createForNoteBlock(NoteBlockInstrument.HARP, pos, note.getVolume(), note.getPitch());
    }

    private static NoteBlockInstrument convertToNoteBlock(int mcId) {
        NoteBlockInstrument[] instruments = NoteBlockInstrument.values();
        if (mcId >= 0 && mcId < instruments.length) {
            return instruments[mcId];
        }
        return NoteBlockInstrument.HARP;
    }

    private static SoundInstance createForNoteBlock(NoteBlockInstrument instrument, Vec3 pos, float volume, float pitch) {
        return new SoundEventInstance((SoundEvent)instrument.getSoundEvent().value(), volume, pitch, pos);
    }

    @Nullable
    public static ResourceLocation parseSoundFile(ResourceManager manager, String file) {
        String path;
        ResourceLocation first = ResourceLocation.tryParse((String)file);
        if (first != null && manager.getResource(Sound.SOUND_LISTER.idToFile(first)).isPresent()) {
            return first;
        }
        int namespaceIndex = file.indexOf("/");
        String namespace = namespaceIndex != -1 ? file.substring(0, namespaceIndex) : file;
        ResourceLocation second = ResourceLocation.tryBuild((String)namespace, (String)(path = namespaceIndex != -1 && file.startsWith(namespace) ? file.substring(namespace.length() + 1) : file));
        if (second != null && manager.getResource(Sound.SOUND_LISTER.idToFile(second)).isPresent()) {
            return second;
        }
        return null;
    }

    @Nullable
    public static SoundEvent parseSoundName(@NotNull String name) {
        ResourceLocation first = ResourceLocation.tryParse((String)name);
        if (first != null && BuiltInRegistries.SOUND_EVENT.containsKey(first)) {
            return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(first);
        }
        if (name.contains(".firework.")) {
            return InstrumentConventer.parseSoundName(name.replace(".firework.", ".firework_rocket."));
        }
        return null;
    }
}

