/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.utils;

import io.github.kosmx.emotes.mc.McUtils;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public enum EmotecraftTexture {
    HEADER_SEPARATOR(Screen.HEADER_SEPARATOR, Screen.INWORLD_HEADER_SEPARATOR),
    FOOTER_SEPARATOR(Screen.FOOTER_SEPARATOR, Screen.INWORLD_FOOTER_SEPARATOR),
    MENU_LIST_BACKGROUND(AbstractSelectionList.MENU_LIST_BACKGROUND, AbstractSelectionList.INWORLD_MENU_LIST_BACKGROUND);

    private final ResourceLocation minecraft;
    private final ResourceLocation minecraftInWorld;
    private final ResourceLocation emotecraft;
    private final ResourceLocation emotecraftInWorld;

    private EmotecraftTexture(ResourceLocation minecraft, ResourceLocation minecraftInWorld) {
        this(minecraft, minecraftInWorld, McUtils.newIdentifier((String)minecraft.getPath()), McUtils.newIdentifier((String)minecraftInWorld.getPath()));
    }

    private EmotecraftTexture(ResourceLocation minecraft, ResourceLocation minecraftInWorld, ResourceLocation emotecraft, ResourceLocation emotecraftInWorld) {
        this.minecraft = minecraft;
        this.minecraftInWorld = minecraftInWorld;
        this.emotecraft = emotecraft;
        this.emotecraftInWorld = emotecraftInWorld;
    }

    public ResourceLocation identifier(boolean inWorld) {
        ResourceManager manager = Minecraft.getInstance().getResourceManager();
        if (inWorld) {
            Optional resourceInWorld = manager.getResource(this.emotecraftInWorld);
            if (resourceInWorld.isPresent()) {
                return this.emotecraftInWorld;
            }
            Optional resource = manager.getResource(this.emotecraft);
            if (resource.isPresent()) {
                return this.emotecraft;
            }
            return this.minecraftInWorld;
        }
        Optional resource = manager.getResource(this.emotecraft);
        return resource.isEmpty() ? this.minecraft : this.emotecraft;
    }
}

