/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.utils;

import com.mojang.authlib.GameProfile;
import io.github.kosmx.emotes.arch.screen.utils.UnsafeClientLevel;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.ClientMannequin;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnsafeMannequin
extends ClientMannequin {
    public UnsafeMannequin(@Nullable ClientLevel clientLevel, GameProfile gameProfile) {
        super((Level)Objects.requireNonNullElse(clientLevel, UnsafeClientLevel.INSTANCE), Minecraft.getInstance().playerSkinRenderCache());
        this.setProfile(ResolvableProfile.createResolved((GameProfile)gameProfile));
        this.setHideDescription(true);
    }

    public boolean isInvisibleTo(Player player) {
        return true;
    }

    public boolean isModelPartShown(PlayerModelPart part) {
        return true;
    }

    public void initEmotePerspective() {
    }

    public boolean touchingUnloadedChunk() {
        return true;
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> fluidTag, double motionScale) {
        return false;
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        return false;
    }

    public void baseTick() {
        ++this.tickCount;
    }

    public void aiStep() {
    }

    public boolean isCustomNameVisible() {
        return false;
    }

    @NotNull
    public BlockState getInBlockState() {
        return Blocks.VOID_AIR.defaultBlockState();
    }

    @NotNull
    public Vec3 position() {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return super.position();
        }
        return localPlayer.position();
    }
}

