/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen.utils;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.ARGB;

public class PageButton
extends AbstractButton {
    public static final int PAGE_BUTTON_WIDTH = 12;
    public static final int PAGE_BUTTON_HEIGHT = 17;
    protected final WidgetSprites sprites;
    protected final boolean drawBackground;
    protected final Consumer<PageButton> onPress;

    public PageButton(WidgetSprites sprites, boolean background, Consumer<PageButton> onPress) {
        this(12, 17, sprites, background, onPress);
    }

    public PageButton(int width, int height, WidgetSprites sprites, boolean background, Consumer<PageButton> onPress) {
        this(0, 0, width, height, sprites, background, onPress);
    }

    public PageButton(int x, int y, int width, int height, WidgetSprites sprites, boolean background, Consumer<PageButton> onPress) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.sprites = sprites;
        this.drawBackground = background;
        this.onPress = onPress;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.drawBackground) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
        int width = this.drawBackground ? 12 : this.getWidth();
        int height = this.drawBackground ? 17 : this.getHeight();
        int x = this.getX();
        int y = this.getY();
        if (this.drawBackground) {
            x += (this.getWidth() - width) / 2;
            y += (this.getHeight() - height) / 2;
        }
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.sprites.get(this.active, this.active && this.isHoveredOrFocused()), x, y, width, height, ARGB.white((float)this.alpha));
        if (this.isHovered()) {
            guiGraphics.requestCursor(this.isActive() ? CursorTypes.POINTING_HAND : CursorTypes.NOT_ALLOWED);
        }
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int color) {
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.onPress.accept(this);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }
}

