/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.screen.EmoteMenu;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.server.serializer.EmoteWriter;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import io.github.kosmx.emotes.server.serializer.type.ISerializer;
import io.github.kosmx.emotes.server.services.InstanceService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class ExportMenu
extends Screen {
    private static final Component TITLE = Component.translatable((String)"emotecraft.options.export");
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    protected final Screen parent;

    public ExportMenu(Screen parent) {
        super(TITLE);
        this.parent = parent;
    }

    public void init() {
        this.layout.addTitleHeader(this.getTitle(), this.font);
        GridLayout gridLayout = new GridLayout();
        gridLayout.defaultCellSetting().paddingHorizontal(8).paddingBottom(4).alignHorizontallyCenter();
        GridLayout.RowHelper rowHelper = gridLayout.createRowHelper(2);
        for (ISerializer serializer : UniversalEmoteSerializer.getSerializers().toList()) {
            rowHelper.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"emotecraft.export", (Object[])new Object[]{serializer.getExtension()}), button -> this.exportEmotesInFormat(serializer)).width(200).build());
        }
        this.layout.addToContents((LayoutElement)gridLayout);
        LinearLayout footer = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        footer.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).build());
        footer.addChild((LayoutElement)Button.builder((Component)EmoteMenu.OPEN_FOLDER, button -> PlatformTools.openExternalEmotesDir()).build());
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void exportEmotesInFormat(ISerializer format) {
        Path exportDir = InstanceService.INSTANCE.getExternalEmoteDir().resolve(format.getExtension() + "_export");
        try {
            Files.createDirectories(exportDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            Animation emote = emoteHolder.getEmote();
            if (emote.data().has("isBuiltin")) continue;
            CommonData.LOGGER.debug("Saving {} into {}", (Object)emoteHolder.name.getString(), (Object)format.getExtension());
            try {
                EmoteWriter.writeAnimationInFormat((Animation)emote, (Path)exportDir, (ISerializer)format);
            }
            catch (Exception e) {
                CommonData.LOGGER.warn("Failed to export!", (Throwable)e);
                PlatformTools.addToast((Component)Component.translatable((String)"emotecraft.export.error", (Object[])new Object[]{format.getExtension()}), emoteHolder.name);
            }
        }
        String exportPath = InstanceService.INSTANCE.getGameDirectory().relativize(exportDir).normalize().toString().replace(File.separator, "/");
        PlatformTools.addToast((Component)Component.translatable((String)"emotecraft.export.done", (Object[])new Object[]{format.getExtension()}), (Component)Component.literal((String)exportPath));
        CommonData.LOGGER.info("All emotes are saved in {} format!", (Object)format.getExtension());
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }
}

