/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.kosmx.emotes.arch.network.EmotePacketPayload;
import io.github.kosmx.emotes.mc.McUtils;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class NetworkPlatformTools {
    public static final CustomPacketPayload.Type<EmotePacketPayload> EMOTE_CHANNEL_ID = new CustomPacketPayload.Type(McUtils.newIdentifier((String)"emote"));
    public static final CustomPacketPayload.Type<EmotePacketPayload> STREAM_CHANNEL_ID = new CustomPacketPayload.Type(McUtils.newIdentifier((String)"stream"));

    @ExpectPlatform
    @Contract
    public static boolean canSendPlay(ServerPlayer player, ResourceLocation channel) {
        throw new AssertionError();
    }

    @ExpectPlatform
    @Contract
    public static boolean canSendConfig(ServerConfigurationPacketListenerImpl player, ResourceLocation channel) {
        throw new AssertionError();
    }

    @ExpectPlatform
    @Contract
    public static Collection<ServerPlayer> getTrackedBy(ServerPlayer player) {
        throw new AssertionError();
    }

    @NotNull
    public static Packet<?> createClientboundPacket(@NotNull CustomPacketPayload.Type<?> id, @NotNull ByteBuffer buf) {
        assert (buf.hasRemaining());
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)new EmotePacketPayload(id, buf));
    }

    @ExpectPlatform
    public static MinecraftServer getServer() {
        throw new AssertionError();
    }

    @NotNull
    public static Packet<?> playPacket(@NotNull ByteBuffer buf) {
        return NetworkPlatformTools.createClientboundPacket(EMOTE_CHANNEL_ID, buf);
    }

    @NotNull
    public static Packet<?> streamPacket(@NotNull ByteBuffer buf) {
        return NetworkPlatformTools.createClientboundPacket(STREAM_CHANNEL_ID, buf);
    }
}

