/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.gui.widgets;

import com.mojang.authlib.GameProfile;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.easing.EasingType;
import io.github.kosmx.emotes.arch.screen.utils.UnsafeRemotePlayer;
import io.github.kosmx.emotes.arch.screen.utils.WidgetOutliner;
import io.github.kosmx.emotes.common.CommonData;
import io.github.kosmx.emotes.main.emotePlay.EmotePlayer;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class PlayerPreview
extends AbstractWidget
implements LayoutElement {
    private static final Float2FloatFunction EASING_TRANSFORMER = EasingType.EASE_OUT_QUART.buildTransformer(null);
    protected final boolean renderBackround;
    protected RemotePlayer player;
    protected float animTime = 1.0f;

    public PlayerPreview(GameProfile profile, int x, int y, int width, int height, boolean renderBackround) {
        super(x, y, width, height, CommonComponents.EMPTY);
        this.player = new UnsafeRemotePlayer(null, profile);
        this.renderBackround = renderBackround;
        this.setAlpha(0.0f);
    }

    public boolean playAnimation(@Nullable Animation animation, Animation.LoopType loopType, boolean check) {
        return this.playAnimation(animation, loopType, check, 0.0f);
    }

    public boolean playAnimation(@Nullable Animation animation, Animation.LoopType loopType, boolean check, float tick) {
        EmotePlayer emotePlayer;
        if (check && animation != null && animation.equals((Object)(emotePlayer = this.player.emotecraft$getEmote()).getCurrentAnimationInstance())) {
            return false;
        }
        this.player.emotecraft$playEmote(animation, loopType, tick, check);
        return true;
    }

    public void pause(boolean paused) {
        EmotePlayer emotePlayer = this.player.emotecraft$getEmote();
        if (paused) {
            emotePlayer.pause();
        } else {
            emotePlayer.unpause();
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushMatrix();
        if (this.renderBackround) {
            float alpha = Mth.lerp((float)this.alpha, (float)0.0f, (float)0.5f);
            guiGraphics.fill(this.getX() + 1, this.getY() + 1, this.getRight() - 1, this.getBottom() - 1, ARGB.colorFromFloat((float)alpha, (float)0.0f, (float)0.0f, (float)0.0f));
            WidgetOutliner.renderOutline(guiGraphics, this, ARGB.white((float)alpha));
        }
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
        try {
            int scale = this.getHeight() / (this.renderBackround ? 3 : 2);
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)this.getX(), (int)this.getY(), (int)this.getRight(), (int)this.getBottom(), (int)Mth.lerpInt((float)this.alpha, (int)0, (int)scale), (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)this.player);
        }
        catch (Throwable th) {
            CommonData.LOGGER.warn("Failed to render entity preview!", th);
        }
        guiGraphics.disableScissor();
        guiGraphics.pose().popMatrix();
        if (this.animTime > 0.0f) {
            this.setAlpha(1.0f - EASING_TRANSFORMER.get(this.animTime));
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        this.defaultButtonNarrationText(narrationElementOutput);
    }

    public void tick() {
        if (this.visible && this.player != null && this.player.isPlayingEmote()) {
            this.animTime = 0.0f;
            this.setAlpha(1.0f);
            try {
                this.player.tick();
            }
            catch (Throwable th) {
                CommonData.LOGGER.warn("Failed to tick entity preview!", th);
            }
        } else {
            this.animTime = Math.min(1.0f, this.animTime + 0.1f);
        }
    }

    public RemotePlayer getPlayer() {
        return this.player;
    }

    public void playDownSound(SoundManager handler) {
    }
}

