package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1007.class)
public abstract class PlayerRendererMixin extends class_922<class_742, class_10055, class_591> {

    public PlayerRendererMixin(class_5617.class_5618 context, class_591 entityModel, float f, Void v) {
        super(context, entityModel, f);
    }

    @Inject(method = "extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V", at = @At("HEAD"))
    private void modifyRenderState(class_742 abstractClientPlayer, class_10055 playerRenderState, float f, CallbackInfo ci) {
        AnimationApplier animation = ((IAnimatedPlayer) abstractClientPlayer).playerAnimator_getAnimation();
        animation.setTickDelta(f);

        ((IPlayerAnimationState)playerRenderState).playerAnimator$setAnimationApplier(animation);
        ((IPlayerAnimationState)playerRenderState).playerAnimator$setLocalPlayer(abstractClientPlayer.method_7340());
        ((IPlayerAnimationState)playerRenderState).playerAnimator$setLocalPlayer(abstractClientPlayer == class_310.method_1551().field_1719);
    }

    @Inject(method = "setupRotations(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;FF)V", at = @At("RETURN"))
    private void applyBodyTransforms(class_10055 playerRenderState, class_4587 matrixStack, float f, float g, CallbackInfo ci){
        var animationPlayer = ((IPlayerAnimationState) playerRenderState).playerAnimator$getAnimationApplier();
        if(animationPlayer.isActive()){

            //These are additive properties
            Vec3f vec3e = animationPlayer.get3DTransform(PartKey.BODY, TransformType.SCALE,
                    new Vec3f(class_630.field_37937, class_630.field_37937, class_630.field_37937)
            );
            matrixStack.method_22905(vec3e.getX(), vec3e.getY(), vec3e.getZ());
            Vec3f vec3d = animationPlayer.get3DTransform(PartKey.BODY, TransformType.POSITION, Vec3f.ZERO);
            matrixStack.method_22904(vec3d.getX(), vec3d.getY() + 0.7, vec3d.getZ());
            Vec3f vec3f = animationPlayer.get3DTransform(PartKey.BODY, TransformType.ROTATION, Vec3f.ZERO);
            matrixStack.method_22907(class_7833.field_40718.rotation(vec3f.getZ()));    //roll
            matrixStack.method_22907(class_7833.field_40716.rotation(vec3f.getY()));    //pitch
            matrixStack.method_22907(class_7833.field_40714.rotation(vec3f.getX()));    //yaw
            matrixStack.method_22904(0, - 0.7d, 0);
        }
    }

    @Inject(method = "extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V", at = @At("TAIL"))
    private void extractRenderState(class_742 abstractClientPlayer, class_10055 playerRenderState, float f, CallbackInfo ci) {
        ((IPlayerAnimationState)playerRenderState).playerAnimator$setCameraEntity(abstractClientPlayer == class_310.method_1551().field_1719);
    }
}
