package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_922;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_922.class)
public class LivingEntityRendererMixin<S extends class_10042, M extends class_583<? super S>> {
    @Shadow protected M model;

    @Inject(method = "render(Lnet/minecraft/client/renderer/entity/state/EntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", at = @At("TAIL"))
    private void render(class_10017 entityRenderState, class_4587 poseStack, class_4597 multiBufferSource, int i, CallbackInfo ci) {
        if (FirstPersonMode.isFirstPersonPass() && entityRenderState instanceof IPlayerAnimationState state
                && state.playerAnimator$isCameraEntity()) {
            playerAnimator$setAllPartsVisible(true);
        }
    }

    @Unique
    private void playerAnimator$setAllPartsVisible(boolean visible) {
        class_591 model = (class_591)this.model;

        model.field_3398.field_3665 = visible;
        model.field_3391.field_3665 = visible;
        model.field_3397.field_3665 = visible;
        model.field_3392.field_3665 = visible;
        model.field_3401.field_3665 = visible;
        model.field_27433.field_3665 = visible;

        // these are children of those ^^^
        //model.hat.visible = visible;
        //model.leftSleeve.visible = visible;
        //model.rightSleeve.visible = visible;
        //model.leftPants.visible = visible;
        //model.rightPants.visible = visible;
        //model.jacket.visible = visible;
    }
}
