package dev.kosmx.playerAnim.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.class_10055;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_972;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_972.class)
public abstract class CapeLayerMixin extends class_3887<class_10055, class_591> {

    @Shadow @Final private class_572<class_10055> model;

    private CapeLayerMixin(class_3883<class_10055, class_591> renderLayerParent, Void v) {
        super(renderLayerParent);
    }

    @Inject(method = "render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/model/HumanoidModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    private void render(class_4587 poseStack, class_4597 multiBufferSource, int i, class_10055 playerRenderState, float f, float g, CallbackInfo ci) {
        AnimationApplier emote = ((IPlayerAnimationState) playerRenderState).playerAnimator$getAnimationApplier();
        if (model instanceof CapeLayerAccessor capeLayer) {
            if (emote.isActive()) {
                class_630 torso = this.method_17165().field_3391;

                poseStack.method_46416(torso.field_3657 / 16, torso.field_3656 / 16, torso.field_3655 / 16);
                poseStack.method_22907((new Quaternionf()).rotateXYZ(torso.field_3654, torso.field_3675, torso.field_3674));

                poseStack.method_46416(0.0F, 0.0F, 0.125F);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180));

                class_630 cape = capeLayer.getCape();
                Vec3f transform = emote.get3DTransform(PartKey.CAPE, TransformType.POSITION, Vec3f.ZERO);
                Vec3f rotation = emote.get3DTransform(PartKey.CAPE, TransformType.ROTATION, Vec3f.ZERO);
                Vec3f scale = emote.get3DTransform(PartKey.CAPE, TransformType.SCALE, Vec3f.ONE);

                cape.field_3657 = transform.getX();
                cape.field_3656 = transform.getY();
                cape.field_3655 = transform.getZ();
                cape.field_3654 = rotation.getX();
                cape.field_3675 = rotation.getY();
                cape.field_3674 = rotation.getZ();
                cape.field_37938 = scale.getX();
                cape.field_37939 = scale.getY();
                cape.field_37940 = scale.getZ();

            }
        }
    }


    @WrapWithCondition(method = "render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V"))
    private boolean translate(class_4587 instance, float f, float g, float h, @Local(argsOnly = true) class_10055 playerRenderState) {
        AnimationApplier emote = ((IPlayerAnimationState) playerRenderState).playerAnimator$getAnimationApplier();
        return !emote.isActive();
    }
}
