package dev.kosmx.playerAnim.mixin;

import Z;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import dev.kosmx.playerAnim.impl.IPlayerModel;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Function;
import net.minecraft.class_10055;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;

@Mixin(value = class_591.class, priority = 2000)//Apply after NotEnoughAnimation's inject
public class PlayerModelMixin<T extends class_1309> extends class_572<class_10055> implements IPlayerModel {
    @Shadow
    @Final
    public class_630 jacket;
    @Shadow
    @Final
    public class_630 rightSleeve;
    @Shadow
    @Final
    public class_630 leftSleeve;
    @Shadow @Final public class_630 rightPants;
    @Shadow @Final public class_630 leftPants;
    @Unique
    private boolean firstPersonNext = false;

    public PlayerModelMixin(class_630 modelPart, Function<class_2960, class_1921> function) {
        super(modelPart, function);
    }

    @Unique
    private void playerAnimator$setDefaultPivot(){
        this.field_3397.method_2851(1.9F, 12.0F, 0.0F);
        this.field_3392.method_2851(- 1.9F, 12.0F, 0.0F);
        this.field_3398.method_2851(0.0F, 0.0F, 0.0F);
        this.field_3401.field_3655 = 0.0F;
        this.field_3401.field_3657 = - 5.0F;
        this.field_27433.field_3655 = 0.0F;
        this.field_27433.field_3657 = 5.0F;
        this.field_3391.field_3654 = 0.0F;
        this.field_3392.field_3655 = 0.1F;
        this.field_3397.field_3655 = 0.1F;
        this.field_3392.field_3656 = 12.0F;
        this.field_3397.field_3656 = 12.0F;
        this.field_3398.field_3656 = 0.0F;
        this.field_3398.field_3674 = 0f;
        this.field_3391.field_3656 = 0.0F;
        this.field_3391.field_3657 = 0f;
        this.field_3391.field_3655 = 0f;
        this.field_3391.field_3675 = 0;
        this.field_3391.field_3674 = 0;

        this.field_3398.field_37938 = class_630.field_37937;
        this.field_3398.field_37939 = class_630.field_37937;
        this.field_3398.field_37940 = class_630.field_37937;
        this.field_3391.field_37938 = class_630.field_37937;
        this.field_3391.field_37939 = class_630.field_37937;
        this.field_3391.field_37940 = class_630.field_37937;
        this.field_3401.field_37938 = class_630.field_37937;
        this.field_3401.field_37939 = class_630.field_37937;
        this.field_3401.field_37940 = class_630.field_37937;
        this.field_27433.field_37938 = class_630.field_37937;
        this.field_27433.field_37939 = class_630.field_37937;
        this.field_27433.field_37940 = class_630.field_37937;
        this.field_3392.field_37938 = class_630.field_37937;
        this.field_3392.field_37939 = class_630.field_37937;
        this.field_3392.field_37940 = class_630.field_37937;
        this.field_3397.field_37938 = class_630.field_37937;
        this.field_3397.field_37939 = class_630.field_37937;
        this.field_3397.field_37940 = class_630.field_37937;
    }

    @Inject(method = "setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V", at = @At(value = "HEAD"))
    private void setDefaultBeforeRender(class_10055 playerRenderState, CallbackInfo ci){
        playerAnimator$setDefaultPivot(); //to not make everything wrong
    }

    @Inject(method = "setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V", at = @At(value = "RETURN"))
    private void setupPlayerAnimation(class_10055 playerRenderState, CallbackInfo ci) {
        if(!firstPersonNext && playerRenderState instanceof IPlayerAnimationState state && state.playerAnimator$getAnimationApplier().isActive()){
            AnimationApplier emote = state.playerAnimator$getAnimationApplier();
            ((IMutableModel)this).playerAnimator$setAnimation(emote);

            emote.updatePart(PartKey.HEAD, this.field_3398);
            emote.updatePart(PartKey.RIGHT_ARM, this.field_3401);
            emote.updatePart(PartKey.LEFT_ARM, this.field_27433);
            emote.updatePart(PartKey.RIGHT_LEG, this.field_3392);
            emote.updatePart(PartKey.LEFT_LEG, this.field_3397);
            emote.updatePart(PartKey.TORSO, this.field_3391);
        }
        else {
            firstPersonNext = false;
            ((IMutableModel)this).playerAnimator$setAnimation(AnimationApplier.EMPTY);
        }

        if (FirstPersonMode.isFirstPersonPass() && playerRenderState instanceof IPlayerAnimationState state
                && state.playerAnimator$isCameraEntity()) {
            var config = state.playerAnimator$getAnimationApplier().getFirstPersonConfiguration();
            // Hiding all parts, because they should not be visible in first person
            playerAnimator$setAllPartsVisible(false);
            // Showing arms based on configuration
            var showRightArm = config.isShowRightArm();
            var showLeftArm = config.isShowLeftArm();
            this.field_3401.field_3665 = showRightArm;
            this.rightSleeve.field_3665 = showRightArm;
            this.field_27433.field_3665 = showLeftArm;
            this.leftSleeve.field_3665 = showLeftArm;
        }
    }

    @WrapWithCondition(method = "translateToHand", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/model/geom/ModelPart;translateAndRotate(Lcom/mojang/blaze3d/vertex/PoseStack;)V"))
    private boolean translateToHand(class_630 modelPart, class_4587 poseStack) {
        if (((IMutableModel)this).playerAnimator$getAnimation().isActive()) {
            poseStack.method_46416(modelPart.field_3657 / 16.0F, modelPart.field_3656 / 16.0F, modelPart.field_3655 / 16.0F);
            if (modelPart.field_3654 != 0.0F || modelPart.field_3675 != 0.0F || modelPart.field_3674 != 0.0F) {
                poseStack.method_22907(new Quaternionf().rotationZYX(modelPart.field_3674, modelPart.field_3675, modelPart.field_3654));
            }
            poseStack.method_22904(0, (modelPart.field_37939 - 1) * 0.609375, (modelPart.field_37940 - 1) * 0.0625);

            return false;
        }
        return true;
    }

    @Unique
    private void playerAnimator$setAllPartsVisible(boolean visible) {
        this.field_3398.field_3665 = visible;
        this.field_3391.field_3665 = visible;
        this.field_3397.field_3665 = visible;
        this.field_3392.field_3665 = visible;
        this.field_3401.field_3665 = visible;
        this.field_27433.field_3665 = visible;

        // these are children of those ^^^
        //this.hat.visible = visible;
        //this.leftSleeve.visible = visible;
        //this.rightSleeve.visible = visible;
        //this.leftPants.visible = visible;
        //this.rightPants.visible = visible;
        //this.jacket.visible = visible;
    }

    /**
     * @author KosmX - Player Animator library
     */
    @Override
    public void playerAnimator_prepForFirstPersonRender() {
        firstPersonNext = true;
    }
}
