package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.Helper;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_989;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_989.class)
public class HeldItemMixin {

    @Inject(method = "renderArmWithItem", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal = 0))
    private void renderMixin(class_1309 livingEntity, class_1799 stack, class_811 itemDisplayContext, class_1306 arm, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci){
        if(Helper.isBendEnabled() && livingEntity instanceof IAnimatedPlayer player){
            if(player.playerAnimator_getAnimation().isActive()){
                AnimationProcessor anim = player.playerAnimator_getAnimation();

                Vec3f data = anim.get3DTransform(arm == class_1306.field_6182 ? "leftArm" : "rightArm", TransformType.BEND, new Vec3f(0f, 0f, 0f));

                Pair<Float, Float> pair = new Pair<>(data.getX(), data.getY());

                float offset = 0.25f;
                matrices.method_46416(0, offset, 0);
                float bend = pair.getRight();
                float axisf = - pair.getLeft();
                Vector3f axis = new Vector3f((float) Math.cos(axisf), 0, (float) Math.sin(axisf));
                //return this.setRotation(axis.getRadialQuaternion(bend));
                matrices.method_22907(new Quaternionf().rotateAxis(bend, axis));
                matrices.method_46416(0, - offset, 0);

            }
        }
    }

    @Inject(method = "renderArmWithItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/ItemInHandRenderer;renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"))
    private void changeItemLocation(class_1309 livingEntity, class_1799 itemStack, class_811 itemDisplayContext, class_1306 arm, class_4587 matrices, class_4597 multiBufferSource, int i, CallbackInfo ci) {
        if(livingEntity instanceof IAnimatedPlayer player) {
            if (player.playerAnimator_getAnimation().isActive()) {
                AnimationProcessor anim = player.playerAnimator_getAnimation();

                Vec3f scale = anim.get3DTransform(arm == class_1306.field_6182 ? "leftItem" : "rightItem", TransformType.SCALE,
                        new Vec3f(class_630.field_37937, class_630.field_37937, class_630.field_37937)
                );
                Vec3f rot = anim.get3DTransform(arm == class_1306.field_6182 ? "leftItem" : "rightItem", TransformType.ROTATION, Vec3f.ZERO);
                Vec3f pos = anim.get3DTransform(arm == class_1306.field_6182 ? "leftItem" : "rightItem", TransformType.POSITION, Vec3f.ZERO).scale(1/16f);

                matrices.method_22905(scale.getX(), scale.getY(), scale.getZ());
                matrices.method_46416(pos.getX(), pos.getY(), pos.getZ());

                matrices.method_22907(class_7833.field_40718.rotation(rot.getZ()));    //roll
                matrices.method_22907(class_7833.field_40716.rotation(rot.getY()));    //pitch
                matrices.method_22907(class_7833.field_40714.rotation(rot.getX()));    //yaw
            }
        }
    }
}
