package dev.kosmx.playerAnim.impl.animation;

import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.impl.Helper;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@ApiStatus.Internal
public interface IBendHelper {

    IBendHelper INSTANCE = Helper.isBendEnabled() ? new BendHelper() : new DummyBendable();
    static void rotateMatrixStack(class_4587 matrices, Pair<Float, Float> pair){
        float offset = 0.375f;
        matrices.method_46416(0, offset, 0);
        float bend = pair.getRight();
        float axisf = - pair.getLeft();
        Vector3f axis = new Vector3f((float) Math.cos(axisf), 0, (float) Math.sin(axisf));
        matrices.method_22907(new Quaternionf().rotateAxis(bend, axis));
        matrices.method_46416(0, - offset, 0);
    }

    void bend(class_630 modelPart, float a, float b);

    void bend(class_630 modelPart, @Nullable Pair<Float, Float> pair);

    void initBend(class_630 modelPart, class_2350 direction);

    void initCapeBend(class_630 modelPart);

    class DummyBendable implements IBendHelper {

        @Override
        public void bend(class_630 modelPart, float a, float b) {

        }

        @Override
        public void bend(class_630 modelPart, @org.jetbrains.annotations.Nullable Pair<Float, Float> pair) {

        }

        @Override
        public void initBend(class_630 modelPart, class_2350 direction) {

        }

        @Override
        public void initCapeBend(class_630 modelPart) {

        }
    }
}
