package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.SetableSupplier;
import dev.kosmx.playerAnim.impl.Helper;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import dev.kosmx.playerAnim.impl.animation.IBendHelper;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_572;
import net.minecraft.class_630;

@Mixin(class_572.class)
public abstract class BipedEntityModelMixin<T extends class_1309> extends class_4592<T> implements IMutableModel {
    @Final
    @Shadow
    public class_630 rightArm;
    @Final
    @Shadow
    public class_630 leftArm;
    @Unique
    private SetableSupplier<AnimationProcessor> animation = new SetableSupplier<>();

    @Inject(method = "<init>(Lnet/minecraft/client/model/geom/ModelPart;Ljava/util/function/Function;)V", at = @At("RETURN"))
    private void initBend(class_630 modelPart, Function<class_2960, class_1921> function, CallbackInfo ci){
        IBendHelper.INSTANCE.initBend(modelPart.method_32086("body"), class_2350.field_11033);
        IBendHelper.INSTANCE.initBend(modelPart.method_32086("right_arm"), class_2350.field_11036);
        IBendHelper.INSTANCE.initBend(modelPart.method_32086("left_arm"), class_2350.field_11036);
        IBendHelper.INSTANCE.initBend(modelPart.method_32086("right_leg"), class_2350.field_11036);
        IBendHelper.INSTANCE.initBend(modelPart.method_32086("left_leg"), class_2350.field_11036);
        ((IUpperPartHelper)rightArm).setUpperPart(true);
        ((IUpperPartHelper)leftArm).setUpperPart(true);
        ((IUpperPartHelper)head).setUpperPart(true);
        ((IUpperPartHelper)hat).setUpperPart(true);
    }

    @Override
    public void setEmoteSupplier(SetableSupplier<AnimationProcessor> emoteSupplier){
        this.animation = emoteSupplier;
    }

    @Inject(method = "copyPropertiesTo", at = @At("RETURN"))
    private void copyMutatedAttributes(class_572<T> bipedEntityModel, CallbackInfo ci){
        if(animation != null) {
            ((IMutableModel) bipedEntityModel).setEmoteSupplier(animation);
        }
    }

    @Intrinsic(displace = true)
    @Override
    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, int color){
        if(Helper.isBendEnabled() && this.animation.get() != null && this.animation.get().isActive()){
            this.method_22946().forEach((part)->{
                if(! ((IUpperPartHelper) part).isUpperPart()){
                    part.method_22699(matrices, vertices, light, overlay, color);
                }
            });
            this.method_22948().forEach((part)->{
                if(! ((IUpperPartHelper) part).isUpperPart()){
                    part.method_22699(matrices, vertices, light, overlay, color);
                }
            });

            SetableSupplier<AnimationProcessor> emoteSupplier = this.animation;
            matrices.method_22903();
            IBendHelper.rotateMatrixStack(matrices, emoteSupplier.get().getBend("body"));
            this.method_22946().forEach((part)->{
                if(((IUpperPartHelper) part).isUpperPart()){
                    part.method_22699(matrices, vertices, light, overlay, color);
                }
            });
            this.method_22948().forEach((part)->{
                if(((IUpperPartHelper) part).isUpperPart()){
                    part.method_22699(matrices, vertices, light, overlay, color);
                }
            });
            matrices.method_22909();
        } else super.method_2828(matrices, vertices, light, overlay, color);
    }

    @Final
    @Shadow public class_630 body;

    @Shadow @Final public class_630 head;

    @Shadow @Final public class_630 hat;

    @Override
    public SetableSupplier<AnimationProcessor> getEmoteSupplier(){
        return animation;
    }
}
