package dev.kosmx.playerAnim.impl.animation;


import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import net.minecraft.class_630;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class AnimationApplier extends AnimationProcessor {
    public AnimationApplier(IAnimation animation) {
        super(animation);
    }

    public void updatePart(String partName, class_630 part) {
        Vec3f pos = this.get3DTransform(partName, TransformType.POSITION, new Vec3f(part.field_3657, part.field_3656, part.field_3655));
        part.field_3657 = pos.getX();
        part.field_3656 = pos.getY();
        part.field_3655 = pos.getZ();
        Vec3f rot = this.get3DTransform(partName, TransformType.ROTATION, new Vec3f( // clamp guards
                MathHelper.clampToRadian(part.field_3654),
                MathHelper.clampToRadian(part.field_3675),
                MathHelper.clampToRadian(part.field_3674)));
        part.method_33425(rot.getX(), rot.getY(), rot.getZ());
        Vec3f scale = this.get3DTransform(partName, TransformType.SCALE,
                new Vec3f(part.field_37938, part.field_37939, part.field_37940)
        );
        part.field_37938 = scale.getX();
        part.field_37939 = scale.getY();
        part.field_37940 = scale.getZ();
        if (!partName.equals("head")) {
            if (partName.equals("torso")) {
                Pair<Float, Float> torsoBend = getBend(partName);
                Pair<Float, Float> bodyBend = getBend("body");
                IBendHelper.INSTANCE.bend(part, new Pair<>(torsoBend.getLeft() + bodyBend.getLeft(), torsoBend.getRight() + bodyBend.getRight()));
            } else {
                IBendHelper.INSTANCE.bend(part, getBend(partName));
            }
        }
    }

}
