package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3887.class)
public class FeatureRendererMixin implements IUpperPartHelper {
    @Unique
    private boolean isUpperPart = true;


    @Inject(method = "<init>", at = @At("RETURN"))
    private void init(class_3883 renderLayerParent, CallbackInfo ci) {
        if (this.getClass().getPackageName().contains("skinlayers") && !this.getClass().getSimpleName().toLowerCase().contains("head")) {
            isUpperPart = false;
        }
    }

    @Override
    public boolean isUpperPart() {
        return this.isUpperPart;
    }

    @Override
    public void setUpperPart(boolean bl) {
        this.isUpperPart = bl;
    }
}
