package dev.kosmx.playerAnim.impl.animation;

import dev.kosmx.playerAnim.core.util.Pair;
import io.github.kosmx.bendylib.ModelPartAccessor;
import io.github.kosmx.bendylib.impl.BendableCuboid;
import net.minecraft.class_2350;
import net.minecraft.class_630;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BendHelper implements IBendHelper {
    @Override
    public void bend(class_630 modelPart, float axis, float rotation){
        // Don't enable bend until rotation is bigger than epsilon. This should avoid unnecessary heavy calculations.
        if (Math.abs(rotation) >= 0.0001f) {
            ModelPartAccessor.optionalGetCuboid(modelPart, 0).ifPresent(mutableCuboid -> ((BendableCuboid) mutableCuboid.getAndActivateMutator("bend")).applyBend(axis, rotation));
        } else {
            ModelPartAccessor.optionalGetCuboid(modelPart, 0).ifPresent(mutableCuboid -> mutableCuboid.getAndActivateMutator(null));
        }
    }

    @Override
    public void bend(class_630 modelPart, @Nullable Pair<Float, Float> pair){
        if(pair != null) {
            this.bend(modelPart, pair.getLeft(), pair.getRight());
        }
        else {
            //ModelPartAccessor.getCuboid(modelPart, 0).getAndActivateMutator(null);
            ModelPartAccessor.optionalGetCuboid(modelPart, 0).ifPresent(mutableCuboid -> mutableCuboid.getAndActivateMutator(null));
        }
    }

    @Override
    public void initBend(class_630 modelPart, class_2350 direction) {
        ModelPartAccessor.optionalGetCuboid(modelPart, 0).ifPresent(mutableModelPart -> mutableModelPart.registerMutator("bend", data -> new BendableCuboid.Builder().setDirection(direction).build(data)));
    }

    @Override
    public void initCapeBend(class_630 modelPart) {
        ModelPartAccessor.optionalGetCuboid(modelPart, 0).ifPresent(mutableModelPart -> mutableModelPart.registerMutator("bend", data -> {
            data.pivot = 6;
            return new BendableCuboid.Builder().setDirection(Direction.UP).build(data);
        }));
    }
}
