/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
implements IAnimatedPlayer {
    @Unique
    private final Map<ResourceLocation, IAnimation> playerAnimator$modAnimationData = new HashMap<ResourceLocation, IAnimation>();
    @Unique
    private final AnimationStack playerAnimator$animationStack = this.playerAnimator$createAnimationStack();
    @Unique
    private final AnimationApplier playerAnimator$animationApplier = new AnimationApplier(this.playerAnimator$animationStack);

    @Unique
    private AnimationStack playerAnimator$createAnimationStack() {
        AnimationStack stack = new AnimationStack();
        if (AbstractClientPlayer.class.isInstance(this)) {
            PlayerAnimationFactory.ANIMATION_DATA_FACTORY.prepareAnimations((AbstractClientPlayer)this, stack, this.playerAnimator$modAnimationData);
            PlayerAnimationAccess.REGISTER_ANIMATION_EVENT.invoker().registerAnimation((AbstractClientPlayer)this, stack);
        }
        return stack;
    }

    @Override
    @NotNull
    public AnimationStack playerAnimator$getAnimationStack() {
        return this.playerAnimator$animationStack;
    }

    @Override
    public AnimationApplier playerAnimator_getAnimation() {
        return this.playerAnimator$animationApplier;
    }

    @Override
    @Nullable
    public IAnimation playerAnimator_getAnimation(@NotNull ResourceLocation id) {
        return this.playerAnimator$modAnimationData.get(id);
    }

    @Override
    @Nullable
    public IAnimation playerAnimator_setAnimation(@NotNull ResourceLocation id, @Nullable IAnimation animation) {
        if (animation == null) {
            return this.playerAnimator$modAnimationData.remove(id);
        }
        return this.playerAnimator$modAnimationData.put(id, animation);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (AbstractClientPlayer.class.isInstance(this)) {
            this.playerAnimator$animationStack.tick();
        }
    }
}

