/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import dev.kosmx.playerAnim.mixin.CapeLayerAccessor;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin
extends RenderLayer<PlayerRenderState, PlayerModel> {
    @Shadow
    @Final
    private HumanoidModel<PlayerRenderState> model;

    private CapeLayerMixin(RenderLayerParent<PlayerRenderState, PlayerModel> renderLayerParent, Void v) {
        super(renderLayerParent);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/HumanoidModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V")})
    private void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, PlayerRenderState playerRenderState, float f, float g, CallbackInfo ci) {
        AnimationApplier emote = ((IPlayerAnimationState)playerRenderState).playerAnimator$getAnimationApplier();
        HumanoidModel<PlayerRenderState> humanoidModel = this.model;
        if (humanoidModel instanceof CapeLayerAccessor) {
            CapeLayerAccessor capeLayer = (CapeLayerAccessor)humanoidModel;
            if (emote.isActive()) {
                ModelPart torso = ((PlayerModel)this.getParentModel()).body;
                poseStack.translate(torso.x / 16.0f, torso.y / 16.0f, torso.z / 16.0f);
                poseStack.mulPose(new Quaternionf().rotateXYZ(torso.xRot, torso.yRot, torso.zRot));
                poseStack.translate(0.0f, 0.0f, 0.125f);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                ModelPart cape = capeLayer.getCape();
                Vec3f transform = emote.get3DTransform(PartKey.CAPE, TransformType.POSITION, Vec3f.ZERO);
                Vec3f rotation = emote.get3DTransform(PartKey.CAPE, TransformType.ROTATION, Vec3f.ZERO);
                Vec3f scale = emote.get3DTransform(PartKey.CAPE, TransformType.SCALE, Vec3f.ONE);
                cape.x = ((Float)transform.getX()).floatValue();
                cape.y = ((Float)transform.getY()).floatValue();
                cape.z = ((Float)transform.getZ()).floatValue();
                cape.xRot = ((Float)rotation.getX()).floatValue();
                cape.yRot = ((Float)rotation.getY()).floatValue();
                cape.zRot = ((Float)rotation.getZ()).floatValue();
                cape.xScale = ((Float)scale.getX()).floatValue();
                cape.yScale = ((Float)scale.getY()).floatValue();
                cape.zScale = ((Float)scale.getZ()).floatValue();
            }
        }
    }

    @WrapWithCondition(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V")})
    private boolean translate(PoseStack instance, float f, float g, float h, @Local(argsOnly=true) PlayerRenderState playerRenderState) {
        AnimationApplier emote = ((IPlayerAnimationState)playerRenderState).playerAnimator$getAnimationApplier();
        return !emote.isActive();
    }
}

