/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.Helper;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class})
public class HeldItemMixin {
    @Inject(method={"renderArmWithItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal=0)})
    private void renderMixin(LivingEntity livingEntity, ItemStack stack, ItemDisplayContext itemDisplayContext, HumanoidArm arm, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        IAnimatedPlayer player;
        if (Helper.isBendEnabled() && livingEntity instanceof IAnimatedPlayer && (player = (IAnimatedPlayer)livingEntity).playerAnimator_getAnimation().isActive()) {
            AnimationApplier anim = player.playerAnimator_getAnimation();
            Vec3f data = anim.get3DTransform(arm == HumanoidArm.LEFT ? "leftArm" : "rightArm", TransformType.BEND, new Vec3f(0.0f, 0.0f, 0.0f));
            Pair<Float, Float> pair = new Pair<Float, Float>((Float)data.getX(), (Float)data.getY());
            float offset = 0.25f;
            matrices.translate(0.0f, offset, 0.0f);
            float bend = pair.getRight().floatValue();
            float axisf = -pair.getLeft().floatValue();
            Vector3f axis = new Vector3f((float)Math.cos(axisf), 0.0f, (float)Math.sin(axisf));
            matrices.mulPose(new Quaternionf().rotateAxis(bend, (Vector3fc)axis));
            matrices.translate(0.0f, -offset, 0.0f);
        }
    }
}

