/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerRenderState, PlayerModel> {
    public PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel entityModel, float f, Void v) {
        super(context, (EntityModel)entityModel, f);
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at={@At(value="HEAD")})
    private void modifyRenderState(AbstractClientPlayer abstractClientPlayer, PlayerRenderState playerRenderState, float f, CallbackInfo ci) {
        AnimationApplier animation = ((IAnimatedPlayer)abstractClientPlayer).playerAnimator_getAnimation();
        animation.setTickDelta(f);
        ((IPlayerAnimationState)playerRenderState).playerAnimator$setAnimationApplier(animation);
        ((IPlayerAnimationState)playerRenderState).playerAnimator$setLocalPlayer(abstractClientPlayer.isLocalPlayer());
        ((IPlayerAnimationState)playerRenderState).playerAnimator$setLocalPlayer(abstractClientPlayer == Minecraft.getInstance().cameraEntity);
    }

    @Inject(method={"setupRotations(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;FF)V"}, at={@At(value="RETURN")})
    private void applyBodyTransforms(PlayerRenderState playerRenderState, PoseStack matrixStack, float f, float g, CallbackInfo ci) {
        AnimationApplier animationPlayer = ((IPlayerAnimationState)playerRenderState).playerAnimator$getAnimationApplier();
        if (animationPlayer.isActive()) {
            Vec3f vec3e = animationPlayer.get3DTransform(PartKey.BODY, TransformType.SCALE, new Vec3f(1.0f, 1.0f, 1.0f));
            matrixStack.scale(((Float)vec3e.getX()).floatValue(), ((Float)vec3e.getY()).floatValue(), ((Float)vec3e.getZ()).floatValue());
            Vec3f vec3d = animationPlayer.get3DTransform(PartKey.BODY, TransformType.POSITION, Vec3f.ZERO);
            matrixStack.translate((double)((Float)vec3d.getX()).floatValue(), (double)((Float)vec3d.getY()).floatValue() + 0.7, (double)((Float)vec3d.getZ()).floatValue());
            Vec3f vec3f = animationPlayer.get3DTransform(PartKey.BODY, TransformType.ROTATION, Vec3f.ZERO);
            matrixStack.mulPose(Axis.ZP.rotation(((Float)vec3f.getZ()).floatValue()));
            matrixStack.mulPose(Axis.YP.rotation(((Float)vec3f.getY()).floatValue()));
            matrixStack.mulPose(Axis.XP.rotation(((Float)vec3f.getX()).floatValue()));
            matrixStack.translate(0.0, -0.7, 0.0);
        }
    }

    @Inject(method={"extractRenderState(Lnet/minecraft/client/player/AbstractClientPlayer;Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;F)V"}, at={@At(value="TAIL")})
    private void extractRenderState(AbstractClientPlayer abstractClientPlayer, PlayerRenderState playerRenderState, float f, CallbackInfo ci) {
        ((IPlayerAnimationState)playerRenderState).playerAnimator$setCameraEntity(abstractClientPlayer == Minecraft.getInstance().cameraEntity);
    }
}

