/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.entity.HumanoidArm;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandLayer.class})
public class HeldItemMixin {
    @Inject(method={"renderArmWithItem(Lnet/minecraft/client/renderer/entity/state/ArmedEntityRenderState;Lnet/minecraft/client/renderer/item/ItemStackRenderState;Lnet/minecraft/world/entity/HumanoidArm;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/item/ItemStackRenderState;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V")})
    private void changeItemLocation(ArmedEntityRenderState renderState, ItemStackRenderState itemStackRenderState, HumanoidArm arm, PoseStack matrices, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        IPlayerAnimationState state;
        if (renderState instanceof IPlayerAnimationState && (state = (IPlayerAnimationState)renderState).playerAnimator$getAnimationApplier().isActive()) {
            AnimationApplier anim = state.playerAnimator$getAnimationApplier();
            Vec3f scale = anim.get3DTransform(arm == HumanoidArm.LEFT ? PartKey.LEFT_ITEM : PartKey.RIGHT_ITEM, TransformType.SCALE, new Vec3f(1.0f, 1.0f, 1.0f));
            Vec3f rot = anim.get3DTransform(arm == HumanoidArm.LEFT ? PartKey.LEFT_ITEM : PartKey.RIGHT_ITEM, TransformType.ROTATION, Vec3f.ZERO);
            Vec3f pos = anim.get3DTransform(arm == HumanoidArm.LEFT ? PartKey.LEFT_ITEM : PartKey.RIGHT_ITEM, TransformType.POSITION, Vec3f.ZERO).scale(0.0625f);
            matrices.scale(((Float)scale.getX()).floatValue(), ((Float)scale.getY()).floatValue(), ((Float)scale.getZ()).floatValue());
            matrices.translate(((Float)pos.getX()).floatValue(), ((Float)pos.getY()).floatValue(), ((Float)pos.getZ()).floatValue());
            matrices.mulPose(Axis.ZP.rotation(((Float)rot.getZ()).floatValue()));
            matrices.mulPose(Axis.YP.rotation(((Float)rot.getY()).floatValue()));
            matrices.mulPose(Axis.XP.rotation(((Float)rot.getX()).floatValue()));
        }
    }
}

