/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WingsLayer.class})
public abstract class ElytraLayerMixin<S extends HumanoidRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private ElytraLayerMixin(RenderLayerParent<S, M> renderLayerParent, Void v) {
        super(renderLayerParent);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/HumanoidRenderState;FF)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;translate(FFF)V")})
    private void inject(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, S humanoidRenderState, float f, float g, CallbackInfo ci) {
        IPlayerAnimationState animationState;
        AnimationApplier emote;
        if (humanoidRenderState instanceof IPlayerAnimationState && (emote = (animationState = (IPlayerAnimationState)humanoidRenderState).playerAnimator$getAnimationApplier()).isActive()) {
            Vec3f translation = emote.get3DTransform(PartKey.TORSO, TransformType.POSITION, Vec3f.ZERO);
            Vec3f rotation = emote.get3DTransform(PartKey.TORSO, TransformType.ROTATION, Vec3f.ZERO);
            translation = emote.get3DTransform(PartKey.CAPE, TransformType.POSITION, translation);
            rotation = emote.get3DTransform(PartKey.CAPE, TransformType.ROTATION, rotation);
            translation = emote.get3DTransform(PartKey.ELYTRA, TransformType.POSITION, translation);
            rotation = emote.get3DTransform(PartKey.ELYTRA, TransformType.ROTATION, rotation);
            poseStack.translate(((Float)translation.getX()).floatValue() / 16.0f, ((Float)translation.getY()).floatValue() / 16.0f, ((Float)translation.getZ()).floatValue() / 16.0f);
            poseStack.mulPose(new Quaternionf().rotateXYZ(((Float)rotation.getX()).floatValue(), ((Float)rotation.getY()).floatValue(), ((Float)rotation.getZ()).floatValue()));
            Vec3f scale = emote.get3DTransform(PartKey.ELYTRA, TransformType.SCALE, Vec3f.ONE);
            poseStack.scale(((Float)scale.getX()).floatValue(), ((Float)scale.getY()).floatValue(), ((Float)scale.getZ()).floatValue());
        }
    }
}

