/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.minecraftApi;

import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlayerAnimationFactory {
    public static final FactoryHolder ANIMATION_DATA_FACTORY = new FactoryHolder();

    @Nullable
    public IAnimation invoke(@NotNull class_742 var1);

    public static class FactoryHolder {
        private static final List<Function<class_742, DataHolder>> factories = new ArrayList<Function<class_742, DataHolder>>();

        private FactoryHolder() {
        }

        public void registerFactory(@Nullable class_2960 id, int priority, @NotNull PlayerAnimationFactory factory) {
            factories.add(player -> Optional.ofNullable(factory.invoke((class_742)player)).map(animation -> new DataHolder(id, priority, (IAnimation)animation)).orElse(null));
        }

        @ApiStatus.Internal
        public void prepareAnimations(class_742 player, AnimationStack playerStack, Map<class_2960, IAnimation> animationMap) {
            for (Function<class_742, DataHolder> factory : factories) {
                DataHolder dataHolder = factory.apply(player);
                if (dataHolder == null) continue;
                playerStack.addAnimLayer(dataHolder.priority(), dataHolder.animation());
                if (dataHolder.id() == null) continue;
                animationMap.put(dataHolder.id(), dataHolder.animation());
            }
        }

        @ApiStatus.Internal
        private record DataHolder(@Nullable class_2960 id, int priority, @NotNull IAnimation animation) {
        }
    }
}

