package dev.kosmx.playerAnim.mixin.firstPerson;

import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

import java.util.List;
import net.minecraft.class_10042;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5697;
import net.minecraft.class_922;

@Mixin(value = class_922.class, priority = 2000)
public class LivingEntityRendererMixin {
    @Shadow
    @Final
    protected List<Object> layers;

    @Redirect(
            method = "render(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V",
            at = @At(value = "FIELD", target = "Lnet/minecraft/client/renderer/entity/LivingEntityRenderer;layers:Ljava/util/List;", opcode = Opcodes.GETFIELD))
    private List<Object> filterLayers(class_922 instance, class_10042 entityRenderState, class_4587 poseStack, class_4597 multiBufferSource, int i) {
        if (entityRenderState instanceof IPlayerAnimationState state && state.playerAnimator$isLocalPlayer() && FirstPersonMode.isFirstPersonPass()) {
            return layers.stream().filter(layer -> layer instanceof class_5697).toList();
        } else return layers;
    }
}
