package dev.kosmx.playerAnim.fabric.client;

import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public class FabricClientInitializer implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger("player-animator");

    @Override
    public void onInitializeClient() {

        ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new SimpleSynchronousResourceReloadListener() {
            @Override
            public class_2960 getFabricId() {
                return PlayerAnimationRegistry.KEY;
            }

            @Override
            public void method_14491(@NotNull class_3300 manager) {
                PlayerAnimationRegistry.resourceLoaderCallback(manager);
            }
        });
    }

}
