package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.impl.Helper;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import dev.kosmx.playerAnim.impl.animation.IBendHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_922;

/**
 * Compatibility issue: can not redirect {@link class_3887#method_4199(class_4587, class_4597, int, class_1297, float, float, float, float, float, float)}
 * I have to modify the matrixStack and do not forget to POP it!
 * <p>
 * I can inject into the enhanced for
 * {@link List#iterator()}      //initial push to keep in sync
 * {@link Iterator#hasNext()}   //to pop the matrix stack
 * {@link Iterator#next()}      //I can see the modelPart, decide if I need to manipulate it. But push always
 *
 * @param <T>
 * @param <M>
 */
@Mixin(class_922.class)
public abstract class LivingEntityRenderRedirect_bendOnly<T extends class_1297, M extends class_583<T>> extends class_897<T> implements class_3883<T, M> {

    protected LivingEntityRenderRedirect_bendOnly(class_5617.class_5618 context) {
        super(context);
    }

    @Inject(method = "render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V",
        at = @At(value = "INVOKE", target = "Ljava/util/List;iterator()Ljava/util/Iterator;"))
    private void initialPush(class_1309 livingEntity, float f, float g, class_4587 poseStack, class_4597 multiBufferSource, int i, CallbackInfo ci){
        if (Helper.isBendEnabled()) poseStack.method_22903();
    }

    @Inject(method = "render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V",
        at = @At(value = "INVOKE", target = "Ljava/util/Iterator;hasNext()Z"))
    private void popMatrixStack(class_1309 livingEntity, float f, float g, class_4587 poseStack, class_4597 multiBufferSource, int i, CallbackInfo ci){
        if (Helper.isBendEnabled()) poseStack.method_22909();
    }

    @Redirect(method = "render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V",
        at = @At(value = "INVOKE", target = "Ljava/util/Iterator;next()Ljava/lang/Object;"))
    private Object transformMatrixStack(Iterator<class_3887<T, M>> instance, class_1309 livingEntity, float f, float g, class_4587 poseStack, class_4597 multiBufferSource, int i){
        if (Helper.isBendEnabled()) {
            poseStack.method_22903();
            class_3887<T, M> layer = instance.next();
            if (livingEntity instanceof class_1657 && livingEntity instanceof IAnimatedPlayer && ((IAnimatedPlayer) livingEntity).playerAnimator_getAnimation().isActive() && ((IUpperPartHelper) layer).isUpperPart()) {
                IBendHelper.rotateMatrixStack(poseStack, ((IAnimatedPlayer) livingEntity).playerAnimator_getAnimation().getBend("body"));
            }
            return layer;
        } else {
            return instance.next();
        }
    }
}
