package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.SetableSupplier;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IPlayerModel;
import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import dev.kosmx.playerAnim.impl.animation.IBendHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;

@Mixin(value = class_591.class, priority = 2000)//Apply after NotEnoughAnimation's inject
public class PlayerModelMixin<T extends class_1309> extends class_572<T> implements IPlayerModel {
    @Shadow
    @Final
    public class_630 jacket;
    @Shadow
    @Final
    public class_630 rightSleeve;
    @Shadow
    @Final
    public class_630 leftSleeve;
    @Shadow @Final public class_630 rightPants;
    @Shadow @Final public class_630 leftPants;
    @Shadow @Final private class_630 cloak;
    @Unique
    private final SetableSupplier<AnimationProcessor> emoteSupplier = new SetableSupplier<>();

    @Unique
    private boolean firstPersonNext = false;

    public PlayerModelMixin(class_630 modelPart, Function<class_2960, class_1921> function) {
        super(modelPart, function);
    }

    @Inject(method = "<init>", at = @At("RETURN"))
    private void initBendableStuff(class_630 modelPart, boolean bl, CallbackInfo ci){
        IMutableModel thisWithMixin = (IMutableModel) this;
        emoteSupplier.set(null);

        thisWithMixin.setEmoteSupplier(emoteSupplier);

        addBendMutator(this.jacket, class_2350.field_11033);
        addBendMutator(this.rightPants, class_2350.field_11036);
        addBendMutator(this.rightSleeve, class_2350.field_11036);
        addBendMutator(this.leftPants, class_2350.field_11036);
        addBendMutator(this.leftSleeve, class_2350.field_11036);
        IBendHelper.INSTANCE.initCapeBend(this.cloak);

        ((IUpperPartHelper)rightSleeve).setUpperPart(true);
        ((IUpperPartHelper)leftSleeve).setUpperPart(true);
    }

    @Unique
    private void addBendMutator(class_630 part, class_2350 d){
        IBendHelper.INSTANCE.initBend(part, d);
    }

    @Unique
    private void setDefaultPivot(){
        this.field_3397.method_2851(1.9F, 12.0F, 0.0F);
        this.field_3392.method_2851(- 1.9F, 12.0F, 0.0F);
        this.field_3398.method_2851(0.0F, 0.0F, 0.0F);
        this.field_3401.field_3655 = 0.0F;
        this.field_3401.field_3657 = - 5.0F;
        this.field_27433.field_3655 = 0.0F;
        this.field_27433.field_3657 = 5.0F;
        this.field_3391.field_3654 = 0.0F;
        this.field_3392.field_3655 = 0.1F;
        this.field_3397.field_3655 = 0.1F;
        this.field_3392.field_3656 = 12.0F;
        this.field_3397.field_3656 = 12.0F;
        this.field_3398.field_3656 = 0.0F;
        this.field_3398.field_3674 = 0f;
        this.field_3391.field_3656 = 0.0F;
        this.field_3391.field_3657 = 0f;
        this.field_3391.field_3655 = 0f;
        this.field_3391.field_3675 = 0;
        this.field_3391.field_3674 = 0;

        this.field_3398.field_37938 = class_630.field_37937;
        this.field_3398.field_37939 = class_630.field_37937;
        this.field_3398.field_37940 = class_630.field_37937;
        this.field_3391.field_37938 = class_630.field_37937;
        this.field_3391.field_37939 = class_630.field_37937;
        this.field_3391.field_37940 = class_630.field_37937;
        this.field_3401.field_37938 = class_630.field_37937;
        this.field_3401.field_37939 = class_630.field_37937;
        this.field_3401.field_37940 = class_630.field_37937;
        this.field_27433.field_37938 = class_630.field_37937;
        this.field_27433.field_37939 = class_630.field_37937;
        this.field_27433.field_37940 = class_630.field_37937;
        this.field_3392.field_37938 = class_630.field_37937;
        this.field_3392.field_37939 = class_630.field_37937;
        this.field_3392.field_37940 = class_630.field_37937;
        this.field_3397.field_37938 = class_630.field_37937;
        this.field_3397.field_37939 = class_630.field_37937;
        this.field_3397.field_37940 = class_630.field_37937;
    }

    @Inject(method = "setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V", at = @At(value = "HEAD"))
    private void setDefaultBeforeRender(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci){
        setDefaultPivot(); //to not make everything wrong
    }

    @Inject(method = "setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/model/geom/ModelPart;copyFrom(Lnet/minecraft/client/model/geom/ModelPart;)V", ordinal = 0))
    private void setEmote(T livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci){
        if(!firstPersonNext && livingEntity instanceof class_742 && ((IAnimatedPlayer)livingEntity).playerAnimator_getAnimation().isActive()){
            AnimationApplier emote = ((IAnimatedPlayer) livingEntity).playerAnimator_getAnimation();
            emoteSupplier.set(emote);

            emote.updatePart("head", this.field_3398);
            this.field_3394.method_17138(this.field_3398);

            emote.updatePart("leftArm", this.field_27433);
            emote.updatePart("rightArm", this.field_3401);
            emote.updatePart("leftLeg", this.field_3397);
            emote.updatePart("rightLeg", this.field_3392);
            emote.updatePart("torso", this.field_3391);
        }
        else {
            firstPersonNext = false;
            emoteSupplier.set(null);
            resetBend(this.field_3391);
            resetBend(this.field_27433);
            resetBend(this.field_3401);
            resetBend(this.field_3397);
            resetBend(this.field_3392);
        }
    }

    @Unique
    private static void resetBend(class_630 part) {
        IBendHelper.INSTANCE.bend(part, null);
    }

    /**
     * @author KosmX - Player Animator library
     */
    @Override
    public void playerAnimator_prepForFirstPersonRender() {
        firstPersonNext = true;
    }
}
