package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3887.class)
public class FeatureRendererMixin implements IUpperPartHelper {
    @Unique
    private boolean playerAnimator$isUpperPart = true;


    @Inject(method = "<init>", at = @At("RETURN"))
    private void init(class_3883<?, ?> renderLayerParent, CallbackInfo ci) {
        if (this.getClass().getPackageName().contains("skinlayers") && !this.getClass().getSimpleName().toLowerCase().contains("head")) {
            playerAnimator$isUpperPart = false;
        }
    }

    @Override
    public boolean playerAnimator$isUpperPart() {
        return this.playerAnimator$isUpperPart;
    }

    @Override
    public void playerAnimator$setUpperPart(boolean bl) {
        this.playerAnimator$isUpperPart = bl;
    }
}
