package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IUpperPartHelper;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Function;
import net.minecraft.class_10034;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;

@Mixin(class_572.class)
public abstract class BipedEntityModelMixin<T extends class_10034> extends class_583<T> implements IMutableModel {
    @Final
    @Shadow
    public class_630 rightArm;
    @Final
    @Shadow
    public class_630 leftArm;

    @Unique
    @NotNull
    private AnimationProcessor playerAnimator$animation = new AnimationApplier(null);

    private BipedEntityModelMixin(Void v, class_630 modelPart) {
        super(modelPart);
    }

    @Inject(method = "<init>(Lnet/minecraft/client/model/geom/ModelPart;Ljava/util/function/Function;)V", at = @At("RETURN"))
    private void initBend(class_630 modelPart, Function<class_2960, class_1921> function, CallbackInfo ci){
        ((IUpperPartHelper)rightArm).playerAnimator$setUpperPart(true);
        ((IUpperPartHelper)leftArm).playerAnimator$setUpperPart(true);
        ((IUpperPartHelper)head).playerAnimator$setUpperPart(true);
        ((IUpperPartHelper)hat).playerAnimator$setUpperPart(true);
    }

    @Override
    public void playerAnimator$setAnimation(@NotNull AnimationProcessor emoteSupplier){
        this.playerAnimator$animation = emoteSupplier;
    }

    @Override
    public @NotNull AnimationProcessor playerAnimator$getAnimation() {
        return this.playerAnimator$animation;
    }

    @Inject(method = "copyPropertiesTo", at = @At("RETURN"))
    private void copyMutatedAttributes(class_572<T> bipedEntityModel, CallbackInfo ci){
        ((IMutableModel) bipedEntityModel).playerAnimator$setAnimation(playerAnimator$animation);
    }

    @Final
    @Shadow public class_630 body;

    @Shadow @Final public class_630 head;

    @Shadow @Final public class_630 hat;

}
