package dev.kosmx.playerAnim.impl.animation;


import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Vec3f;
import net.minecraft.class_630;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationApplier extends AnimationProcessor {
    public AnimationApplier(@Nullable IAnimation animation) {
        super(animation);
    }

    public void updatePart(@NotNull PartKey partKey, class_630 part) {
        Vec3f pos = this.get3DTransform(partKey, TransformType.POSITION, new Vec3f(part.field_3657, part.field_3656, part.field_3655));
        part.field_3657 = pos.getX();
        part.field_3656 = pos.getY();
        part.field_3655 = pos.getZ();
        Vec3f rot = this.get3DTransform(partKey, TransformType.ROTATION, new Vec3f( // clamp guards
                MathHelper.clampToRadian(part.field_3654),
                MathHelper.clampToRadian(part.field_3675),
                MathHelper.clampToRadian(part.field_3674)));
        part.method_33425(rot.getX(), rot.getY(), rot.getZ());
        Vec3f scale = this.get3DTransform(partKey, TransformType.SCALE,
                new Vec3f(part.field_37938, part.field_37939, part.field_37940)
        );
        part.field_37938 = scale.getX();
        part.field_37939 = scale.getY();
        part.field_37940 = scale.getZ();
    }

    public static final @NotNull AnimationApplier EMPTY = new AnimationApplier(null);
}
