/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.minecraftApi;

import dev.kosmx.playerAnim.api.IPlayer;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.impl.event.Event;
import dev.kosmx.playerAnim.impl.IAnimatedPlayer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class PlayerAnimationAccess {
    public static final Event<AnimationRegister> REGISTER_ANIMATION_EVENT = new Event<AnimationRegister>(AnimationRegister.class, listeners -> (player, animationStack) -> {
        for (AnimationRegister listener : listeners) {
            listener.registerAnimation(player, animationStack);
        }
    });

    public static AnimationStack getPlayerAnimLayer(class_742 player) throws IllegalArgumentException {
        if (player instanceof IPlayer) {
            return ((IPlayer)player).playerAnimator$getAnimationStack();
        }
        throw new IllegalArgumentException(String.valueOf(player) + " is not a player or library mixins failed");
    }

    public static PlayerAssociatedAnimationData getPlayerAssociatedData(@NotNull class_742 player) {
        if (player instanceof IAnimatedPlayer) {
            IAnimatedPlayer animatedPlayer = (IAnimatedPlayer)player;
            return new PlayerAssociatedAnimationData(animatedPlayer);
        }
        throw new IllegalArgumentException(String.valueOf(player) + " is not a player or library mixins failed");
    }

    public static class PlayerAssociatedAnimationData {
        @NotNull
        private final IAnimatedPlayer player;

        public PlayerAssociatedAnimationData(@NotNull IAnimatedPlayer player) {
            this.player = player;
        }

        @Nullable
        public IAnimation get(@NotNull class_2960 id) {
            return this.player.playerAnimator_getAnimation(id);
        }

        @Nullable
        public IAnimation set(@NotNull class_2960 id, @Nullable IAnimation animation) {
            return this.player.playerAnimator_setAnimation(id, animation);
        }
    }

    @FunctionalInterface
    public static interface AnimationRegister {
        public void registerAnimation(@NotNull class_742 var1, @NotNull AnimationStack var2);
    }
}

