/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.api.layered;

import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerAnimationFrame
implements IAnimation {
    protected PlayerPart head = new PlayerPart();
    protected PlayerPart body = new PlayerPart();
    protected PlayerPart rightArm = new PlayerPart();
    protected PlayerPart leftArm = new PlayerPart();
    protected PlayerPart rightLeg = new PlayerPart();
    protected PlayerPart leftLeg = new PlayerPart();
    protected PlayerPart rightItem = new PlayerPart();
    protected PlayerPart leftItem = new PlayerPart();
    HashMap<PartKey, PlayerPart> parts = new HashMap();

    public PlayerAnimationFrame() {
        this.parts.put(PartKey.HEAD, this.head);
        this.parts.put(PartKey.BODY, this.body);
        this.parts.put(PartKey.RIGHT_ARM, this.rightArm);
        this.parts.put(PartKey.LEFT_ARM, this.leftArm);
        this.parts.put(PartKey.RIGHT_LEG, this.rightLeg);
        this.parts.put(PartKey.LEFT_LEG, this.leftLeg);
        this.parts.put(PartKey.RIGHT_ITEM, this.rightItem);
        this.parts.put(PartKey.LEFT_ITEM, this.leftItem);
    }

    @Override
    public void tick() {
        IAnimation.super.tick();
    }

    @Override
    public boolean isActive() {
        for (Map.Entry<PartKey, PlayerPart> entry : this.parts.entrySet()) {
            PlayerPart part = entry.getValue();
            if (part.bend == null && part.pos == null && part.rot == null && part.scale == null) continue;
            return true;
        }
        return false;
    }

    public void resetPose() {
        for (Map.Entry<PartKey, PlayerPart> entry : this.parts.entrySet()) {
            entry.getValue().setNull();
        }
    }

    @Override
    @NotNull
    public Vec3f get3DTransform(@NotNull PartKey modelKey, @NotNull TransformType type, float tickDelta, @NotNull Vec3f value0) {
        PlayerPart part = this.parts.get(modelKey);
        if (part == null) {
            return value0;
        }
        return switch (type) {
            case TransformType.POSITION -> {
                if (part.pos == null) {
                    yield value0;
                }
                yield part.pos;
            }
            case TransformType.ROTATION -> {
                if (part.rot == null) {
                    yield value0;
                }
                yield part.rot;
            }
            case TransformType.SCALE -> {
                if (part.scale == null) {
                    yield value0;
                }
                yield part.scale;
            }
            case TransformType.BEND -> {
                if (part.bend == null) {
                    yield value0;
                }
                yield new Vec3f(part.bend.getLeft().floatValue(), part.bend.getRight().floatValue(), 0.0f);
            }
            default -> value0;
        };
    }

    public static class PlayerPart {
        public Vec3f pos;
        public Vec3f scale;
        public Vec3f rot;
        public Pair<Float, Float> bend;

        protected void setNull() {
            this.rot = null;
            this.scale = null;
            this.pos = null;
            this.bend = null;
        }
    }
}

