/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.impl;

import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationProcessor {
    @Nullable
    private final IAnimation animation;
    private float tickDelta = 0.0f;

    public AnimationProcessor(@Nullable IAnimation animation) {
        this.animation = animation;
    }

    @ApiStatus.Internal
    public void tick() {
        if (this.animation != null) {
            this.animation.tick();
        }
    }

    public boolean isActive() {
        return this.animation != null && this.animation.isActive();
    }

    @Deprecated(forRemoval=true)
    public Vec3f get3DTransform(String modelKey, TransformType type, Vec3f value0) {
        return this.get3DTransform(PartKey.keyForId(modelKey), type, value0);
    }

    public Vec3f get3DTransform(PartKey partKey, TransformType type, Vec3f value0) {
        if (this.animation == null) {
            return value0;
        }
        return this.animation.get3DTransform(partKey, type, this.tickDelta, value0);
    }

    @ApiStatus.Internal
    public void setTickDelta(float tickDelta) {
        this.tickDelta = tickDelta;
        if (this.animation != null) {
            this.animation.setupAnim(tickDelta);
        }
    }

    @ApiStatus.Experimental
    @Nullable
    public IAnimation getAnimation() {
        return this.animation;
    }

    public boolean isFirstPersonAnimationDisabled() {
        return this.animation == null || !this.animation.getFirstPersonMode(this.tickDelta).isEnabled();
    }

    @NotNull
    public FirstPersonMode getFirstPersonMode() {
        return this.animation == null ? FirstPersonMode.NONE : this.animation.getFirstPersonMode(this.tickDelta);
    }

    @NotNull
    public FirstPersonConfiguration getFirstPersonConfiguration() {
        return this.animation == null ? new FirstPersonConfiguration() : this.animation.getFirstPersonConfiguration(this.tickDelta);
    }

    @NotNull
    public Pair<Float, Float> getBend(PartKey partKey) {
        if (this.animation == null) {
            return new Pair<Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
        Vec3f bendVec = this.get3DTransform(partKey, TransformType.BEND, Vec3f.ZERO);
        return new Pair<Float, Float>((Float)bendVec.getX(), (Float)bendVec.getY());
    }

    public int getPriority() {
        IAnimation iAnimation = this.animation;
        if (iAnimation instanceof AnimationStack) {
            AnimationStack animationStack = (AnimationStack)iAnimation;
            return animationStack.getPriority();
        }
        return 0;
    }
}

