/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.api.layered;

import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IActualAnimation;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyframeAnimationPlayer
implements IActualAnimation<KeyframeAnimationPlayer> {
    private final KeyframeAnimation data;
    private boolean isRunning = true;
    private int currentTick;
    private boolean isLoopStarted = false;
    protected float tickDelta;
    public final HashMap<PartKey, BodyPart> bodyParts;
    public int perspective = 0;
    @NotNull
    private FirstPersonConfiguration firstPersonConfiguration = new FirstPersonConfiguration();
    @NotNull
    private FirstPersonMode firstPersonMode = FirstPersonMode.NONE;

    public float getTickDelta() {
        return this.tickDelta;
    }

    @Override
    @NotNull
    public FirstPersonConfiguration getFirstPersonConfiguration(float tickDelta) {
        return this.firstPersonConfiguration;
    }

    @Override
    @NotNull
    public FirstPersonMode getFirstPersonMode(float tickDelta) {
        return this.firstPersonMode;
    }

    public KeyframeAnimationPlayer(@NotNull KeyframeAnimation animation, int t, boolean mutable) {
        if (animation == null) {
            throw new IllegalArgumentException("Animation can not be null");
        }
        this.data = animation;
        this.bodyParts = new HashMap(animation.getBodyParts().size());
        for (Map.Entry<PartKey, KeyframeAnimation.StateCollection> part : animation.getKeyBodyParts().entrySet()) {
            this.bodyParts.put(part.getKey(), new BodyPart(mutable ? part.getValue().copy() : part.getValue()));
        }
        this.currentTick = t;
        if (this.isInfinite() && t > this.data.returnToTick) {
            this.currentTick = (t - this.data.returnToTick) % (this.data.endTick - this.data.returnToTick + 1) + this.data.returnToTick;
        }
    }

    public KeyframeAnimationPlayer(@NotNull KeyframeAnimation animation, int t) {
        this(animation, t, false);
    }

    public KeyframeAnimationPlayer(@NotNull KeyframeAnimation animation) {
        this(animation, 0);
    }

    @Override
    public void tick() {
        if (this.isRunning) {
            ++this.currentTick;
            if (this.data.isInfinite && this.currentTick > this.data.endTick) {
                this.currentTick = this.data.returnToTick;
                this.isLoopStarted = true;
            }
            if (this.currentTick >= this.data.stopTick) {
                this.stop();
            }
        }
    }

    public int getTick() {
        return this.currentTick;
    }

    public void stop() {
        this.isRunning = false;
    }

    @Override
    public boolean isActive() {
        return this.isRunning;
    }

    @Override
    @NotNull
    public Vec3f get3DTransform(@NotNull PartKey modelKey, @NotNull TransformType type, float tickDelta, @NotNull Vec3f value0) {
        BodyPart part = this.bodyParts.get(modelKey);
        if (part == null) {
            return value0;
        }
        return switch (type) {
            case TransformType.POSITION -> part.getBodyOffset(value0);
            case TransformType.ROTATION -> {
                Vec3f rot = part.getBodyRotation(value0);
                yield new Vec3f(((Float)rot.getX()).floatValue(), ((Float)rot.getY()).floatValue(), ((Float)rot.getZ()).floatValue());
            }
            case TransformType.BEND -> {
                Pair<Float, Float> bend = part.getBend(new Pair<Float, Float>((Float)value0.getX(), (Float)value0.getY()));
                yield new Vec3f(bend.getLeft().floatValue(), bend.getRight().floatValue(), 0.0f);
            }
            case TransformType.SCALE -> part.getScale(value0);
            default -> value0;
        };
    }

    @Override
    public void setupAnim(float tickDelta) {
        this.tickDelta = tickDelta;
    }

    public boolean isLoopStarted() {
        return this.isLoopStarted;
    }

    public KeyframeAnimation getData() {
        return this.data;
    }

    public BodyPart getPart(String string) {
        BodyPart part = this.bodyParts.get(string);
        return part == null ? new BodyPart(null) : part;
    }

    public int getStopTick() {
        return this.data.stopTick;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public boolean isInfinite() {
        return this.data.isInfinite;
    }

    @Override
    @Generated
    public KeyframeAnimationPlayer setFirstPersonConfiguration(@NotNull FirstPersonConfiguration firstPersonConfiguration) {
        if (firstPersonConfiguration == null) {
            throw new NullPointerException("firstPersonConfiguration is marked non-null but is null");
        }
        this.firstPersonConfiguration = firstPersonConfiguration;
        return this;
    }

    @Override
    @Generated
    public KeyframeAnimationPlayer setFirstPersonMode(@NotNull FirstPersonMode firstPersonMode) {
        if (firstPersonMode == null) {
            throw new NullPointerException("firstPersonMode is marked non-null but is null");
        }
        this.firstPersonMode = firstPersonMode;
        return this;
    }

    public class BodyPart {
        @Nullable
        public final KeyframeAnimation.StateCollection part;
        public final Axis x;
        public final Axis y;
        public final Axis z;
        public final RotationAxis pitch;
        public final RotationAxis yaw;
        public final RotationAxis roll;
        public final RotationAxis bendAxis;
        public final RotationAxis bend;
        public final Axis scaleX;
        public final Axis scaleY;
        public final Axis scaleZ;

        public BodyPart(KeyframeAnimation.StateCollection part) {
            this.part = part;
            if (part != null) {
                this.x = new Axis(part.x);
                this.y = new Axis(part.y);
                this.z = new Axis(part.z);
                this.pitch = new RotationAxis(part.pitch);
                this.yaw = new RotationAxis(part.yaw);
                this.roll = new RotationAxis(part.roll);
                this.bendAxis = new RotationAxis(part.bendDirection);
                this.bend = new RotationAxis(part.bend);
                this.scaleX = new Axis(part.scaleX);
                this.scaleY = new Axis(part.scaleY);
                this.scaleZ = new Axis(part.scaleZ);
            } else {
                this.x = null;
                this.y = null;
                this.z = null;
                this.pitch = null;
                this.yaw = null;
                this.roll = null;
                this.bendAxis = null;
                this.bend = null;
                this.scaleX = null;
                this.scaleY = null;
                this.scaleZ = null;
            }
        }

        public Pair<Float, Float> getBend(Pair<Float, Float> value0) {
            if (this.bend == null) {
                return value0;
            }
            return new Pair<Float, Float>(Float.valueOf(this.bendAxis.getValueAtCurrentTick(value0.getLeft().floatValue())), Float.valueOf(this.bend.getValueAtCurrentTick(value0.getRight().floatValue())));
        }

        public Vec3f getScale(Vec3f value0) {
            if (this.part == null) {
                return value0;
            }
            return new Vec3f(this.scaleX.getValueAtCurrentTick(((Float)value0.getX()).floatValue()), this.scaleY.getValueAtCurrentTick(((Float)value0.getY()).floatValue()), this.scaleZ.getValueAtCurrentTick(((Float)value0.getZ()).floatValue()));
        }

        public Vec3f getBodyOffset(Vec3f value0) {
            if (this.part == null) {
                return value0;
            }
            float x = this.x.getValueAtCurrentTick(((Float)value0.getX()).floatValue());
            float y = this.y.getValueAtCurrentTick(((Float)value0.getY()).floatValue());
            float z = this.z.getValueAtCurrentTick(((Float)value0.getZ()).floatValue());
            return new Vec3f(x, y, z);
        }

        public Vec3f getBodyRotation(Vec3f value0) {
            if (this.part == null) {
                return value0;
            }
            return new Vec3f(this.pitch.getValueAtCurrentTick(((Float)value0.getX()).floatValue()), this.yaw.getValueAtCurrentTick(((Float)value0.getY()).floatValue()), this.roll.getValueAtCurrentTick(((Float)value0.getZ()).floatValue()));
        }
    }

    public class RotationAxis
    extends Axis {
        public RotationAxis(KeyframeAnimation.StateCollection.State keyframes) {
            super(keyframes);
        }

        @Override
        public float getValueAtCurrentTick(float currentValue) {
            return MathHelper.clampToRadian(super.getValueAtCurrentTick(MathHelper.clampToRadian(currentValue)));
        }
    }

    public class Axis {
        protected final KeyframeAnimation.StateCollection.State keyframes;

        public Axis(KeyframeAnimation.StateCollection.State keyframes) {
            this.keyframes = keyframes;
        }

        private KeyframeAnimation.KeyFrame findBefore(int pos, float currentState) {
            if (pos == -1) {
                return KeyframeAnimationPlayer.this.currentTick < KeyframeAnimationPlayer.this.data.beginTick ? new KeyframeAnimation.KeyFrame(0, currentState) : (KeyframeAnimationPlayer.this.currentTick < KeyframeAnimationPlayer.this.data.endTick ? new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.data.beginTick, this.keyframes.defaultValue) : new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.data.endTick, this.keyframes.defaultValue));
            }
            KeyframeAnimation.KeyFrame frame = this.keyframes.getKeyFrames().get(pos);
            if (!KeyframeAnimationPlayer.this.isInfinite() && KeyframeAnimationPlayer.this.currentTick >= KeyframeAnimationPlayer.this.getData().endTick && pos == this.keyframes.length() - 1 && frame.tick < KeyframeAnimationPlayer.this.getData().endTick) {
                return new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().endTick, frame.value, frame.ease, frame.easingArg);
            }
            return frame;
        }

        private KeyframeAnimation.KeyFrame findAfter(int pos, float currentState) {
            if (this.keyframes.length() > pos + 1) {
                return this.keyframes.getKeyFrames().get(pos + 1);
            }
            if (KeyframeAnimationPlayer.this.isInfinite()) {
                return new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().endTick + 1, this.keyframes.defaultValue);
            }
            if (KeyframeAnimationPlayer.this.currentTick < KeyframeAnimationPlayer.this.getData().endTick && this.keyframes.length() > 0) {
                KeyframeAnimation.KeyFrame lastFrame = this.keyframes.getKeyFrames().get(this.keyframes.length() - 1);
                return new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().endTick, lastFrame.value, lastFrame.ease, lastFrame.easingArg);
            }
            return KeyframeAnimationPlayer.this.currentTick >= KeyframeAnimationPlayer.this.data.endTick ? new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.data.stopTick, currentState) : (KeyframeAnimationPlayer.this.currentTick >= KeyframeAnimationPlayer.this.getData().beginTick ? new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().endTick, this.keyframes.defaultValue) : new KeyframeAnimation.KeyFrame(KeyframeAnimationPlayer.this.getData().beginTick, this.keyframes.defaultValue));
        }

        public float getValueAtCurrentTick(float currentValue) {
            if (this.keyframes != null && this.keyframes.isEnabled()) {
                int pos = this.keyframes.findAtTick(KeyframeAnimationPlayer.this.currentTick);
                KeyframeAnimation.KeyFrame keyBefore = this.findBefore(pos, currentValue);
                if (KeyframeAnimationPlayer.this.isLoopStarted && keyBefore.tick < KeyframeAnimationPlayer.this.data.returnToTick) {
                    keyBefore = this.findBefore(this.keyframes.findAtTick(KeyframeAnimationPlayer.this.data.endTick), currentValue);
                }
                KeyframeAnimation.KeyFrame keyAfter = this.findAfter(pos, currentValue);
                if (KeyframeAnimationPlayer.this.data.isInfinite && keyAfter.tick > KeyframeAnimationPlayer.this.data.endTick) {
                    keyAfter = this.findAfter(this.keyframes.findAtTick(KeyframeAnimationPlayer.this.data.returnToTick - 1), currentValue);
                }
                return this.getValueFromKeyframes(keyBefore, keyAfter);
            }
            return currentValue;
        }

        protected final float getValueFromKeyframes(KeyframeAnimation.KeyFrame before, KeyframeAnimation.KeyFrame after) {
            int tickBefore = before.tick;
            int tickAfter = after.tick;
            if (tickBefore >= tickAfter) {
                if (KeyframeAnimationPlayer.this.currentTick < tickBefore) {
                    tickBefore -= KeyframeAnimationPlayer.this.data.endTick - KeyframeAnimationPlayer.this.data.returnToTick + 1;
                } else {
                    tickAfter += KeyframeAnimationPlayer.this.data.endTick - KeyframeAnimationPlayer.this.data.returnToTick + 1;
                }
            }
            if (tickBefore == tickAfter) {
                return before.value;
            }
            float f = ((float)KeyframeAnimationPlayer.this.currentTick + KeyframeAnimationPlayer.this.tickDelta - (float)tickBefore) / (float)(tickAfter - tickBefore);
            KeyframeAnimation.KeyFrame getEaseFrom = KeyframeAnimationPlayer.this.data.isEasingBefore ? after : before;
            return MathHelper.lerp(getEaseFrom.ease.invoke(f, getEaseFrom.easingArg), before.value, after.value);
        }
    }
}

